/*
 * Decompiled with CFR 0.152.
 */
package act.internal.util;

import act.internal.util.JavaNames;
import act.internal.util.NoisyWordsFilter;
import java.util.List;
import org.osgl.util.C;
import org.osgl.util.Keyword;
import org.osgl.util.S;

class AppNameInferer {
    AppNameInferer() {
    }

    static String from(Class<?> entryClass) {
        List<String> tokens = AppNameInferer.tokenOf(entryClass);
        return AppNameInferer.fromTokens(tokens);
    }

    static String fromPackageName(String packageName) {
        List<String> tokens = AppNameInferer.tokenOf(packageName);
        return AppNameInferer.fromTokens(tokens);
    }

    private static String fromTokens(List<String> tokens) {
        List<String> filtered = NoisyWordsFilter.filter(tokens);
        String joined = S.join((String)".", filtered);
        return Keyword.of((CharSequence)joined).httpHeader();
    }

    private static List<String> tokenOf(Class<?> entryClass) {
        C.List tokens = C.newList();
        tokens.addAll(AppNameInferer.classNameTokensReversed(entryClass));
        Class<?> enclosingClass = entryClass.getEnclosingClass();
        while (null != enclosingClass) {
            tokens.addAll(AppNameInferer.classNameTokensReversed(enclosingClass));
            enclosingClass = entryClass.getEnclosingClass();
        }
        String pkgName = JavaNames.packageNameOf(entryClass);
        tokens.append(S.fastSplit((String)pkgName, (String)".").reverse());
        return tokens.reverse();
    }

    private static List<String> tokenOf(String packageName) {
        return S.fastSplit((String)packageName, (String)".");
    }

    private static List<String> classNameTokensReversed(Class theClass) {
        return C.list((List)Keyword.of((CharSequence)theClass.getSimpleName()).tokens()).reverse();
    }
}

