/*
 * Decompiled with CFR 0.152.
 */
package act.internal.util;

import act.Act;
import act.conf.ActConfig;

public class StrBufRetentionLimitCalculator {
    public int calculate() {
        long availableKilobytes = this.availableMemorySize() / 1024L;
        long reservedForStrBuf = availableKilobytes / 128L;
        long reservedForStrBufPerThread = reservedForStrBuf / (long)this.threadsCount();
        return (int)reservedForStrBufPerThread;
    }

    private long availableMemorySize() {
        Runtime rt = Runtime.getRuntime();
        rt.gc();
        return rt.freeMemory();
    }

    private int threadsCount() {
        int workerThreads = Runtime.getRuntime().availableProcessors() * 2 * 8;
        ActConfig conf = Act.conf();
        int maxWorkerThreads = null == conf ? 0 : conf.xioMaxWorkerThreads();
        return maxWorkerThreads > 0 ? Math.min(maxWorkerThreads, workerThreads) : workerThreads;
    }

    public static void main(String[] args) {
        System.out.println(new StrBufRetentionLimitCalculator().calculate());
    }
}

