/*
 * Decompiled with CFR 0.152.
 */
package act.job;

import act.cli.Command;
import act.cli.Optional;
import act.cli.Required;
import act.cli.TableView;
import act.event.OnEvent;
import act.job.Job;
import act.job.JobManager;
import act.util.JsonView;
import act.util.PropertySpec;
import act.util.SimpleProgressGauge;
import act.ws.WebSocketConnectEvent;
import act.ws.WebSocketConnectionManager;
import act.ws.WebSocketContext;
import act.ws.WsEndpoint;
import com.alibaba.fastjson.JSONObject;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.inject.Inject;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.S;

public class JobAdmin {
    private static Comparator<Job> _UNIQ_JOB_FILTER = new Comparator<Job>(){

        @Override
        public int compare(Job o1, Job o2) {
            return o1.id().compareTo(o2.id());
        }
    };

    @Command(value="act.job.list", help="List jobs")
    @PropertySpec(value={"id,oneTime,executed,trigger"})
    @TableView
    public List<Job> listJobs(final @Optional(lead={"-q"}) String q, JobManager jobManager) {
        C.List jobs = jobManager.jobs().append(jobManager.virtualJobs()).unique(_UNIQ_JOB_FILTER);
        if (S.notBlank((String)q)) {
            jobs = jobs.filter((Lang.Function)new Lang.Predicate<Job>(){

                public boolean test(Job job) {
                    return job.toString().contains(q);
                }
            });
        }
        return jobs;
    }

    @JsonView
    @Command(value="act.job.show", help="Show job details")
    @PropertySpec(value={"id,oneTime,executed,trigger,worker"})
    public Job getJob(@Required(value="specify job id") String id, JobManager jobManager) {
        return jobManager.jobById(id);
    }

    @Command(value="act.job.progress", help="Show job progress")
    public int getJobProgress(@Required(value="specify job id") String id, JobManager jobManager) {
        Job job = jobManager.jobById(id);
        return null == job ? -1 : job.getProgressInPercent();
    }

    @Command(name="act.job.cancel", help="Cancel a job")
    public void cancel(@Required(value="specify job id") String id, JobManager jobManager) {
        jobManager.cancel(id);
    }

    @Command(value="act.job.scheduler", help="Show Job manager scheduler status")
    public String getSchedulerStatus(JobManager jobManager) {
        ScheduledThreadPoolExecutor executor = jobManager.executor();
        JSONObject json = new JSONObject();
        json.put("is terminating", (Object)executor.isTerminating());
        json.put("is terminated", (Object)executor.isTerminated());
        json.put("is shutdown", (Object)executor.isShutdown());
        json.put("# of runnable in the queue", (Object)executor.getQueue().size());
        json.put("active count", (Object)executor.getActiveCount());
        json.put("# of completed tasks", (Object)executor.getActiveCount());
        json.put("core pool size", (Object)executor.getCorePoolSize());
        json.put("pool size", (Object)executor.getPoolSize());
        return json.toJSONString();
    }

    public static class WebsocketEndpoints {

        @WsEndpoint(value={"/~/job/{id}/progress"})
        public static class JobProgress {
            @Inject
            private WebSocketConnectionManager connectionManager;

            @OnEvent
            public void onConnect(WebSocketConnectEvent event) {
                WebSocketContext context = (WebSocketContext)event.source();
                String jobId = context.actionContext().paramVal("id");
                String tag = SimpleProgressGauge.wsJobProgressTag(jobId);
                this.connectionManager.subscribe(context.actionContext().session(), tag);
            }
        }
    }
}

