/*
 * Decompiled with CFR 0.152.
 */
package act.job.meta;

import act.Destroyable;
import act.asm.Type;
import act.job.meta.JobClassMetaInfo;
import act.util.AsmTypes;
import act.util.DestroyableBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class JobClassMetaInfoManager
extends DestroyableBase {
    private Map<String, JobClassMetaInfo> jobs = new HashMap<String, JobClassMetaInfo>();
    private Map<Type, List<JobClassMetaInfo>> subTypeInfo = new HashMap<Type, List<JobClassMetaInfo>>();

    @Override
    protected void releaseResources() {
        Destroyable.Util.destroyAll(this.jobs.values(), ApplicationScoped.class);
        this.jobs.clear();
        for (List<JobClassMetaInfo> l : this.subTypeInfo.values()) {
            Destroyable.Util.destroyAll(l, ApplicationScoped.class);
        }
        this.subTypeInfo.clear();
        super.releaseResources();
    }

    public void registerJobMetaInfo(JobClassMetaInfo metaInfo) {
        List<JobClassMetaInfo> subTypes;
        JobClassMetaInfo superInfo;
        Type superType;
        String className = Type.getObjectType((String)metaInfo.className()).getClassName();
        this.jobs.put(className, metaInfo);
        if (metaInfo.isJob() && !AsmTypes.OBJECT_TYPE.equals((Object)(superType = metaInfo.superType())) && null == (superInfo = this.jobMetaInfo(superType.getClassName()))) {
            List<JobClassMetaInfo> subTypes2 = this.subTypeInfo.get(superType);
            if (null == subTypes2) {
                subTypes2 = new ArrayList<JobClassMetaInfo>();
            }
            subTypes2.add(metaInfo);
        }
        if (null != (subTypes = this.subTypeInfo.get(metaInfo.type()))) {
            this.subTypeInfo.remove(metaInfo.type());
        }
        this.logger.trace("Job meta info registered for: %s", new Object[]{className});
    }

    public JobClassMetaInfo jobMetaInfo(String className) {
        return this.jobs.get(className);
    }
}

