/*
 * Decompiled with CFR 0.152.
 */
package act.mail;

import act.app.ActionContext;
import act.mail.MailerContext;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.osgl.Lang;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.storage.ISObject;
import org.osgl.storage.impl.SObject;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE})
public @interface Mailer {
    public String value() default "default";

    public static class Util {
        protected static final Logger logger = L.get(Mailer.class);
        private static final ThreadLocal<SimpleContext> _ctx = new ThreadLocal<SimpleContext>(){

            @Override
            protected SimpleContext initialValue() {
                return new SimpleContext();
            }
        };

        public static Future<Boolean> send(Object ... args) {
            throw E.unsupport((String)"to be enhanced", (Object[])new Object[0]);
        }

        public static MailerContext mailer() {
            throw E.unsupport((String)"to be enhanced", (Object[])new Object[0]);
        }

        public static void from(String from) {
            Util.ctx().from = from;
        }

        public static void to(List<String> recipients) {
            Util.ctx().to = S.join((String)",", recipients);
        }

        public static void to(String ... recipients) {
            Util.ctx().to = S.join((String)",", (String[])recipients);
        }

        public static void cc(String ... cc) {
            Util.ctx().cc = S.join((String)",", (String[])cc);
        }

        public static void bcc(String ... bcc) {
            Util.ctx().bcc = S.join((String)",", (String[])bcc);
        }

        public static void subject(String subject, Object ... args) {
            Util.ctx().subject = subject;
            Util.ctx().subjectArgs = args;
        }

        public static void attach(SObject ... attachments) {
            Util.ctx().attachments.addAll((Collection<ISObject>)C.listOf((Object[])attachments));
        }

        public static void attach(ISObject ... attachments) {
            Util.ctx().attachments.addAll((Collection<ISObject>)C.listOf((Object[])attachments));
        }

        public static void attach(Collection<? extends ISObject> attachments) {
            Util.ctx().attachments.addAll(attachments);
        }

        public static void attach(File ... attachments) {
            if (attachments.length == 0) {
                return;
            }
            Util.attachFiles((Collection<File>)C.listOf((Object[])attachments));
        }

        public static void attachFiles(Collection<File> attachments) {
            if (attachments.isEmpty()) {
                return;
            }
            Util.attach((Collection<? extends ISObject>)C.list(attachments).map((Lang.Function)new Lang.Transformer<File, SObject>(){

                public SObject transform(File file) {
                    return SObject.of((File)file);
                }
            }));
        }

        public static void content(String content, Object ... args) {
            Util.ctx().content = null != content ? S.fmt((String)content, (Object[])args) : null;
        }

        public static void templatePath(String templatePath, Object ... args) {
            Util.ctx().templatePath = null == templatePath ? null : S.fmt((String)templatePath, (Object[])args);
        }

        private static SimpleContext ctx() {
            return _ctx.get();
        }

        public static Future<Boolean> doSendWithoutLoadThreadLocal(final MailerContext context) {
            return context.app().jobManager().now(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return context.send();
                }
            });
        }

        public static Future<Boolean> doSend(final MailerContext context) {
            Util.tryLoadLocale(context);
            SimpleContext ctx = _ctx.get();
            if (null != ctx) {
                if (S.notBlank((String)ctx.from)) {
                    context.from(ctx.from);
                }
                if (S.notBlank((String)ctx.to)) {
                    context.to(ctx.to);
                }
                if (S.notBlank((String)ctx.cc)) {
                    context.cc(ctx.cc);
                }
                if (S.notBlank((String)ctx.bcc)) {
                    context.bcc(ctx.bcc);
                }
                if (S.notBlank((String)ctx.subject)) {
                    context.subject(ctx.subject, ctx.subjectArgs);
                }
                if (!ctx.attachments.isEmpty()) {
                    context.attach(ctx.attachments);
                }
                if (null != ctx.content) {
                    context.content(ctx.content, new Object[0]);
                }
                if (S.notBlank((String)ctx.templatePath)) {
                    context.templatePath(ctx.templatePath);
                }
                _ctx.remove();
            }
            return context.app().jobManager().now(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return context.send();
                }
            });
        }

        private static void tryLoadLocale(MailerContext context) {
            if (!context.config().i18nEnabled() || context.locale() != null) {
                return;
            }
            for (Map.Entry<String, Object> entry : context.renderArgs().entrySet()) {
                Object val = entry.getValue();
                if (!(val instanceof ActionContext)) continue;
                context.locale(((ActionContext)val).locale());
                return;
            }
            context.locale(context.config().locale());
        }

        private static class SimpleContext {
            String from;
            String to;
            String cc;
            String bcc;
            String subject;
            Object[] subjectArgs;
            String content;
            String templatePath;
            List<ISObject> attachments = new ArrayList<ISObject>();

            private SimpleContext() {
            }
        }
    }
}

