/*
 * Decompiled with CFR 0.152.
 */
package act.mail;

import act.Act;
import act.app.ActionContext;
import act.app.App;
import act.event.ActEvent;
import act.event.SystemEvent;
import act.mail.MailerConfig;
import act.util.ActContext;
import act.view.Template;
import act.view.ViewManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.osgl.$;
import org.osgl.concurrent.ContextLocal;
import org.osgl.http.H;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.storage.ISObject;
import org.osgl.storage.impl.SObject;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class MailerContext
extends ActContext.Base<MailerContext> {
    private static final Logger logger = LogManager.get(MailerContext.class);
    private H.Format fmt = H.Format.HTML;
    private InternetAddress from;
    private String subject;
    private String content;
    private List<InternetAddress> to = new ArrayList<InternetAddress>();
    private List<InternetAddress> cc = new ArrayList<InternetAddress>();
    private List<InternetAddress> bcc = new ArrayList<InternetAddress>();
    private String confId;
    private List<ISObject> attachments = new ArrayList<ISObject>();
    private String senderPath;
    private static final ContextLocal<MailerContext> _local = $.contextLocal();
    private static final String SEP = "[;:,]+";

    public MailerContext(App app, String confId) {
        this(app, confId, null);
    }

    public MailerContext(App app, String confId, String templateContext) {
        super(app);
        this.confId = confId;
        _local.set((Object)this);
        ActionContext actionContext = ActionContext.current();
        if (null != actionContext) {
            this.locale(actionContext.locale());
        }
        app.eventBus().triggerSync(new InitEvent(this), new Object[0]);
        super.templateContext(templateContext);
    }

    @Override
    protected void releaseResources() {
        super.releaseResources();
        this.to.clear();
        this.cc.clear();
        this.bcc.clear();
        _local.remove();
    }

    public MailerContext configId(String id) {
        this.confId = id;
        return this;
    }

    public String senderPath() {
        return this.senderPath;
    }

    public MailerContext senderPath(String path) {
        this.senderPath = path;
        return this;
    }

    @Override
    public String methodPath() {
        return this.senderPath;
    }

    public MailerContext senderPath(String className, String methodName) {
        this.senderPath = S.concat((String)className, (String)".", (String)methodName);
        return this;
    }

    public MailerConfig mailerConfig() {
        return this.app().mailerConfigManager().config(this.confId);
    }

    public Set<String> paramKeys() {
        throw E.tbd();
    }

    public String paramVal(String key) {
        throw E.tbd();
    }

    public String[] paramVals(String key) {
        throw E.tbd();
    }

    @Override
    public MailerContext accept(H.Format fmt) {
        E.NPE((Object)fmt);
        this.fmt = fmt;
        return this;
    }

    @Override
    public H.Format accept() {
        return null != this.fmt ? this.fmt : this.mailerConfig().contentType();
    }

    @Override
    public MailerContext templatePath(String templatePath) {
        return (MailerContext)super.templatePath(templatePath);
    }

    @Override
    public MailerContext templateLiteral(String literal) {
        return (MailerContext)super.templateLiteral(literal);
    }

    @Override
    public <T> T renderArg(String name) {
        return super.renderArg(name);
    }

    @Override
    public MailerContext renderArg(String name, Object val) {
        return (MailerContext)super.renderArg(name, val);
    }

    @Override
    public Map<String, Object> renderArgs() {
        return super.renderArgs();
    }

    public MailerContext __appRenderArgNames(String names) {
        return this.renderArg("__arg_names__", C.listOf((Object[])names.split(",")));
    }

    public List<String> __appRenderArgNames() {
        return (List)this.renderArg("__arg_names__");
    }

    public H.Format contentType() {
        return this.accept();
    }

    public String subject() {
        return null != this.subject ? this.subject : this.mailerConfig().subject();
    }

    public MailerContext subject(String subject, Object ... args) {
        this.subject = this.app().config().i18nEnabled() ? this.i18n(subject, args) : S.fmt((String)subject, (Object[])args);
        return this;
    }

    public MailerContext content(String content, Object ... args) {
        this.content = null != content ? S.fmt((String)content, (Object[])args) : null;
        return this;
    }

    public MailerContext attach(ISObject ... attachments) {
        this.attachments.addAll((Collection<ISObject>)C.listOf((Object[])attachments));
        return this;
    }

    public MailerContext attach(Collection<ISObject> attachments) {
        this.attachments.addAll(attachments);
        return this;
    }

    public MailerContext attach(File ... files) {
        for (File file : files) {
            this.attachments.add((ISObject)SObject.of((File)file));
        }
        return this;
    }

    public MailerContext from(String from) {
        E.illegalArgumentIf((boolean)S.empty((String)from), (String)"<from> cannot be empty");
        List<InternetAddress> l = MailerContext.canonicalRecipients(null, from);
        E.illegalArgumentIf((boolean)l.isEmpty(), (String)"from address expected");
        if (l.size() > 1) {
            logger.warn("There are more than one email address specified, only the first one will be used as From address");
        }
        this.from = l.get(0);
        return this;
    }

    public InternetAddress from() {
        if (null == this.from) {
            return this.mailerConfig().from();
        }
        return this.from;
    }

    public MailerContext to(String ... recipients) {
        this.to = MailerContext.canonicalRecipients(null, recipients);
        return this;
    }

    public List<InternetAddress> to() {
        return this.to.isEmpty() ? this.mailerConfig().to() : this.to;
    }

    public MailerContext cc(String ... recipients) {
        this.cc = MailerContext.canonicalRecipients(null, recipients);
        return this;
    }

    public List<InternetAddress> cc() {
        return this.cc.isEmpty() ? this.mailerConfig().ccList() : this.cc;
    }

    public MailerContext bcc(String ... recipients) {
        this.bcc = MailerContext.canonicalRecipients(null, recipients);
        return this;
    }

    public List<InternetAddress> bcc() {
        return this.bcc.isEmpty() ? this.mailerConfig().bccList() : this.bcc;
    }

    public MailerContext addTo(String ... recipients) {
        MailerContext.canonicalRecipients(this.to, recipients);
        return this;
    }

    public MailerContext addCc(String ... recipients) {
        MailerContext.canonicalRecipients(this.cc, recipients);
        return this;
    }

    public MailerContext addBcc(String ... recipients) {
        MailerContext.canonicalRecipients(this.bcc, recipients);
        return this;
    }

    public boolean send() {
        try {
            MimeMessage message = this.createMessage();
            if (!this.mailerConfig().mock()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Sending email\n%sEnd email\n", new Object[]{this.debug(message)});
                }
                Transport.send((Message)message);
            } else {
                logger.info("Sending email\n%sEnd email\n", new Object[]{this.debug(message)});
            }
            return true;
        }
        catch (Exception e) {
            logger.error((Throwable)e, "Error sending email: %s", new Object[]{this});
            return false;
        }
    }

    private String debug(MimeMessage msg) throws Exception {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\n>> recipients");
        Address[] aa = msg.getAllRecipients();
        if (null != aa) {
            for (Address a : aa) {
                lines.add(a.getType() + ":" + a.toString());
            }
        } else {
            lines.add("[ERROR] no recipients defined");
        }
        lines.add(">> header lines");
        Enumeration e = msg.getAllHeaderLines();
        while (e.hasMoreElements()) {
            lines.add(S.string(e.nextElement()));
        }
        Object content = msg.getContent();
        if (content instanceof Multipart) {
            lines.add(">> multipart content");
            Multipart mp = (Multipart)content;
            for (int i = 0; i < mp.getCount(); ++i) {
                MimeBodyPart bp = (MimeBodyPart)mp.getBodyPart(i);
                lines.add(S.fmt((String)">>> #%s [%s]", (Object[])new Object[]{i, bp.getContentType()}));
                String fileName = bp.getFileName();
                if (S.notBlank((String)fileName)) {
                    lines.add("file: " + fileName);
                    continue;
                }
                lines.add(S.string((Object)bp.getContent()));
            }
        } else {
            lines.add(">> content[" + msg.getContentType() + "]");
            lines.add(S.string((Object)msg.getContent()));
        }
        lines.add("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
        return S.join((String)"\n", lines);
    }

    private MimeMessage createMessage() throws Exception {
        MailerConfig config = this.mailerConfig();
        if (null == config) {
            throw E.unexpected((String)"Cannot find mailer config for %s", (Object[])new Object[]{this.confId});
        }
        Session session = this.mailerConfig().session();
        if (Act.isDev()) {
            session.setDebug(true);
        }
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)this.from());
        msg.setSubject(this.subject());
        msg.setSentDate(new Date());
        msg.setRecipients(Message.RecipientType.TO, (Address[])MailerContext.list2Array(this.to()));
        msg.setRecipients(Message.RecipientType.CC, (Address[])MailerContext.list2Array(this.cc()));
        msg.setRecipients(Message.RecipientType.BCC, (Address[])MailerContext.list2Array(this.bcc()));
        String content = this.content;
        if (null == content) {
            ViewManager vm = Act.viewManager();
            Template t = vm.load(this);
            E.illegalStateIf((null == t ? 1 : 0) != 0, (String)"Mail template not defined");
            content = t.render(this);
        }
        if (this.attachments.isEmpty()) {
            msg.setText(content, this.config().encoding(), this.accept().name());
        } else {
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart bp = new MimeBodyPart();
            mp.addBodyPart((BodyPart)bp);
            bp.setText(content, this.config().encoding(), this.accept().name());
            for (ISObject sobj : this.attachments) {
                String contentType;
                String fileName = sobj.getAttribute("filename");
                if (S.blank((String)fileName)) {
                    fileName = sobj.getKey();
                }
                if (S.blank((String)(contentType = sobj.getAttribute("content-type")))) {
                    contentType = "application/octet-stream";
                }
                MimeBodyPart attachment = new MimeBodyPart();
                attachment.attachFile(sobj.asFile(), contentType, null);
                attachment.setFileName(fileName);
                mp.addBodyPart((BodyPart)attachment);
            }
            msg.setContent((Multipart)mp);
        }
        msg.saveChanges();
        return msg;
    }

    private static InternetAddress[] list2Array(List<InternetAddress> list) {
        int len = list.size();
        InternetAddress[] array = new InternetAddress[len];
        return list.toArray(array);
    }

    public static MailerContext current() {
        return (MailerContext)_local.get();
    }

    public static List<InternetAddress> canonicalRecipients(List<InternetAddress> l, String ... recipients) {
        if (null == l) {
            l = new ArrayList<InternetAddress>();
        }
        if (recipients.length == 0) {
            return l;
        }
        String s = S.join((String)",", (String[])recipients).replaceAll(SEP, ",");
        try {
            Object[] aa = InternetAddress.parse((String)s);
            l.addAll((Collection<InternetAddress>)C.listOf((Object[])aa));
            return l;
        }
        catch (AddressException e) {
            throw E.unexpected((Throwable)e);
        }
    }

    public static class InitEvent
    extends ActEvent<MailerContext>
    implements SystemEvent {
        public InitEvent(MailerContext source) {
            super(source);
        }

        @Override
        public Class<? extends ActEvent<MailerContext>> eventType() {
            return InitEvent.class;
        }
    }
}

