/*
 * Decompiled with CFR 0.152.
 */
package act.mail.bytecode;

import act.app.App;
import act.asm.ClassVisitor;
import act.asm.MethodVisitor;
import act.asm.Type;
import act.mail.bytecode.SenderEnhancer;
import act.mail.meta.MailerClassMetaInfo;
import act.mail.meta.MailerClassMetaInfoHolder;
import act.mail.meta.SenderMethodMetaInfo;
import act.util.AppByteCodeEnhancer;
import org.osgl.Lang;
import org.osgl.util.S;

public class MailerEnhancer
extends AppByteCodeEnhancer<MailerEnhancer> {
    private MailerClassMetaInfoHolder classInfoHolder;
    private String className;

    public MailerEnhancer() {
        super((Lang.Predicate<String>)S.F.startsWith((String)"act.").negate().or(new Lang.Function[]{S.F.startsWith((String)"act.fsa")}));
    }

    public MailerEnhancer(ClassVisitor cv, MailerClassMetaInfoHolder infoHolder) {
        super((Lang.Predicate<String>)_F.isMailer(infoHolder), cv);
        this.classInfoHolder = infoHolder;
    }

    @Override
    public AppByteCodeEnhancer app(App app) {
        this.classInfoHolder = app.classLoader();
        return super.app(app);
    }

    @Override
    protected Class<MailerEnhancer> subClass() {
        return MailerEnhancer.class;
    }

    @Override
    protected void reset() {
        this.className = null;
        super.reset();
    }

    public MailerEnhancer classInfoHolder(MailerClassMetaInfoHolder holder) {
        this.classInfoHolder = holder;
        this.predicate((Lang.Predicate<String>)_F.isMailer(holder));
        return this;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = Type.getObjectType((String)name).getClassName();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        SenderMethodMetaInfo info = this.methodInfo(name, access);
        if (null == info) {
            return mv;
        }
        logger.debug(">>>About to enhance mailer method: %s", new Object[]{name});
        return new SenderEnhancer(mv, info, access, name, desc, signature, exceptions);
    }

    private SenderMethodMetaInfo methodInfo(String name, int access) {
        if (MailerEnhancer.isPublic(access) && !MailerEnhancer.isConstructor(name)) {
            MailerClassMetaInfo ccInfo = this.classInfoHolder.mailerClassMetaInfo(this.className);
            if (null == ccInfo) {
                return null;
            }
            SenderMethodMetaInfo info = ccInfo.sender(name);
            if (null != info) {
                return info;
            }
            return ccInfo.sender(name);
        }
        return null;
    }

    private boolean isTargetMethod(String name, int access) {
        return MailerEnhancer.isPublic(access) && !MailerEnhancer.isConstructor(name) && this.methodInfo(name, access) != null;
    }

    private static enum _F {


        private static final Lang.Predicate<String> isMailer(final MailerClassMetaInfoHolder infoSrc) {
            return new Lang.Predicate<String>(){

                public boolean test(String s) {
                    return infoSrc.mailerClassMetaInfo(s) != null;
                }
            };
        }
    }
}

