/*
 * Decompiled with CFR 0.152.
 */
package act.mail.meta;

import act.Destroyable;
import act.asm.Type;
import act.mail.meta.SenderMethodMetaInfo;
import act.util.DestroyableBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.util.S;

@ApplicationScoped
public final class MailerClassMetaInfo
extends DestroyableBase {
    private Type type;
    private String configId;
    private boolean isAbstract = false;
    private String ctxField = null;
    private boolean ctxFieldIsPrivate = true;
    private List<SenderMethodMetaInfo> senders = new ArrayList<SenderMethodMetaInfo>();
    private Map<String, SenderMethodMetaInfo> mailerLookup = null;
    private boolean isMailer;
    private String contextPath;
    private String templateContext;

    public MailerClassMetaInfo className(String name) {
        this.type = Type.getObjectType((String)name);
        return this;
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.destroyAll(this.senders, ApplicationScoped.class);
        this.senders.clear();
        if (null != this.mailerLookup) {
            Destroyable.Util.destroyAll(this.mailerLookup.values(), ApplicationScoped.class);
            this.mailerLookup.clear();
        }
        super.releaseResources();
    }

    public String className() {
        return this.type.getClassName();
    }

    public MailerClassMetaInfo configId(String id) {
        this.configId = id;
        return this;
    }

    public String configId() {
        return this.configId;
    }

    public MailerClassMetaInfo templateContext(String templateContext) {
        this.templateContext = templateContext;
        return this;
    }

    public String templateContext() {
        return this.templateContext;
    }

    public String internalName() {
        return this.type.getInternalName();
    }

    public Type type() {
        return this.type;
    }

    public MailerClassMetaInfo setAbstract() {
        this.isAbstract = true;
        return this;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isMailer() {
        return this.isMailer;
    }

    public MailerClassMetaInfo isMailer(boolean b) {
        this.isMailer = b;
        return this;
    }

    public MailerClassMetaInfo ctxField(String fieldName, boolean isPrivate) {
        this.ctxField = fieldName;
        this.ctxFieldIsPrivate = isPrivate;
        return this;
    }

    public String nonPrivateCtxField() {
        if (null != this.ctxField) {
            return this.ctxFieldIsPrivate ? null : this.ctxField;
        }
        return null;
    }

    public String ctxField() {
        if (null != this.ctxField) {
            return this.ctxField;
        }
        return null;
    }

    public boolean hasCtxField() {
        return null != this.ctxField;
    }

    public boolean ctxFieldIsPrivate() {
        return this.ctxFieldIsPrivate;
    }

    public MailerClassMetaInfo addSender(SenderMethodMetaInfo info) {
        this.senders.add(info);
        return this;
    }

    public SenderMethodMetaInfo sender(String name) {
        if (null == this.mailerLookup) {
            for (SenderMethodMetaInfo act : this.senders) {
                if (!S.eq((String)name, (String)act.name())) continue;
                return act;
            }
            return null;
        }
        return this.mailerLookup.get(name);
    }

    public String contextPath() {
        return this.contextPath;
    }

    public MailerClassMetaInfo contextPath(String path) {
        this.contextPath = S.blank((String)path) ? "/" : path;
        return this;
    }
}

