/*
 * Decompiled with CFR 0.152.
 */
package act.metric;

import org.osgl.util.E;
import org.osgl.util.S;

enum CountScale {
    nil("", 1L),
    kilo("k", 1000L),
    million("m", 1000000L),
    billion("b", 1000000000L),
    tera("t", 1000000000000L),
    peta("p", 1000000000000000L),
    exa("e", 1000000000000000000L);

    long value;
    String suffix;

    private CountScale(long value) {
        this.value = value;
    }

    private CountScale(String suffix, long value) {
        this.value = value;
        this.suffix = suffix;
    }

    public static String format(long count) {
        E.illegalArgumentIf((count < 0L ? 1 : 0) != 0, (String)"counts cannot be negative number");
        if (count == 0L) {
            return "0";
        }
        CountScale last = exa;
        for (CountScale s : CountScale.values()) {
            if (s.value > count) break;
            last = s;
        }
        if (last == nil) {
            return S.string((Object)count);
        }
        long l = count / (last.value / 100L);
        String s = S.str((Object)l).insert(-2, '.').toString();
        if (s.endsWith(".00")) {
            s = s.substring(0, s.length() - 3);
        }
        return S.fmt((String)"%s%s", (Object[])new Object[]{s, last.suffix()});
    }

    private String suffix() {
        String suffix = this.suffix;
        if (null == suffix) {
            suffix = this.name();
        }
        return suffix;
    }
}

