/*
 * Decompiled with CFR 0.152.
 */
package act.metric;

import org.osgl.util.E;
import org.osgl.util.S;

enum DurationScale {
    ns(1L),
    ms(1000000L),
    second("s", 1000000000L),
    minute("min", 60000000000L),
    hour("h", 3600000000000L),
    day("d", 86400000000000L),
    week(" week(s)", 604800000000000L),
    mon(" month(s)", 2592000000000000L),
    year(" year(s)", 31536000000000000L);

    long value;
    String suffix;

    private DurationScale(long value) {
        this.value = value;
    }

    private DurationScale(String suffix, long value) {
        this.value = value;
        this.suffix = suffix;
    }

    public static String format(long ns) {
        String s;
        E.illegalArgumentIf((ns < 0L ? 1 : 0) != 0, (String)"duration cannot be negative number");
        if (ns == 0L) {
            return "0";
        }
        DurationScale last = year;
        for (DurationScale s2 : DurationScale.values()) {
            if (s2.value > ns) break;
            last = s2;
        }
        if (last == DurationScale.ns) {
            if (ns > 10000L) {
                last = ms;
                long l = ns * 100L / last.value;
                s = S.str((Object)l).prepend("0").insert(-2, '.').toString();
            } else {
                s = S.string((Object)ns);
            }
        } else {
            long l = ns / (last.value / 100L);
            s = S.str((Object)l).insert(-2, '.').toString();
        }
        if (s.startsWith(".")) {
            s = S.concat((String)"0", (String)s);
        }
        return S.concat((String)s, (String)last.suffix);
    }

    private String suffix() {
        String suffix = this.suffix;
        if (null == suffix) {
            suffix = this.name();
        }
        return suffix;
    }
}

