/*
 * Decompiled with CFR 0.152.
 */
package act.metric;

import act.Act;
import act.cli.CliContext;
import act.cli.Command;
import act.cli.Optional;
import act.metric.MetricInfo;
import act.metric.MetricInfoTree;
import act.util.PropertySpec;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.osgl.Lang;
import org.osgl.util.C;

public class MetricAdmin {
    @Command(name="act.metric.sync")
    public void updateMetricDataSync(@Optional(value="pause sync") boolean pause, CliContext context) {
        Act.metricPlugin().enableDataSync(!pause);
        context.println(pause ? "metric data sync paused." : "metric data sync enabled", new Object[0]);
    }

    @Command(name="act.metric.counter.list", help="list all counters")
    @PropertySpec(value={"name,count"})
    public Object getCounters(@Optional(value="specify maximum items returned") Integer limit, @Optional(value="display in tree view") boolean tree, @Optional(value="specify depth of levels") Integer depth, @Optional(value="specify search string") String q, @Optional(value="including classloading metric") boolean classLoading) {
        List<MetricInfo> list = Act.metricPlugin().metricStore().timers();
        if (!classLoading) {
            list = this.withoutClassLoading(list);
        }
        return this.process(list, limit, q, tree, depth, (Comparator<MetricInfo>)MetricInfo.Comparator.COUNTER, MetricInfoTree.COUNTER);
    }

    @Command(name="act.metric.timer.list", help="list all timers")
    @PropertySpec(value={"name,accumulated,count,avg"})
    public Object getTimers(@Optional(value="specify maximum items returned") Integer limit, @Optional(value="display in tree view") boolean tree, @Optional(value="specify depth of levels") Integer depth, @Optional(value="specify search string") String q, @Optional(value="including classloading metric") boolean classLoading) {
        List<MetricInfo> list = Act.metricPlugin().metricStore().timers();
        if (!classLoading) {
            list = this.withoutClassLoading(list);
        }
        return this.process(list, limit, q, tree, depth, (Comparator<MetricInfo>)MetricInfo.Comparator.TIMER, MetricInfoTree.TIMER);
    }

    private List<MetricInfo> withoutClassLoading(List<MetricInfo> list) {
        return C.list(list).remove((Lang.Function)new Lang.Predicate<MetricInfo>(){

            public boolean test(MetricInfo metricInfo) {
                return metricInfo.getName().startsWith("act:classload");
            }
        });
    }

    @Command(name="act.metric.clear", help="clear existing metric data")
    public void clearMetricData() {
        Act.metricPlugin().metricStore().clear();
    }

    private Object process(List<MetricInfo> list, Integer max, final String q, boolean asTree, final Integer level, Comparator<MetricInfo> comp, MetricInfoTree.NodeDecorator decorator) {
        Lang.Predicate filter = Lang.F.yes();
        if (null != level) {
            filter = new Lang.Predicate<String>(){

                public boolean test(String path) {
                    String[] sa = path.split(":");
                    return sa.length <= level;
                }
            };
        }
        if (null != q) {
            final Pattern p = Pattern.compile(q);
            filter = filter.and(new Lang.Function[]{new Lang.Predicate<String>(){

                public boolean test(String path) {
                    return path.contains(q) || p.matcher(path).matches();
                }
            }});
        }
        final Lang.Predicate theFilter = filter;
        if (!asTree) {
            list = C.list(list).filter((Lang.Function)new Lang.Predicate<MetricInfo>(){

                public boolean test(MetricInfo metricInfo) {
                    return theFilter.test((Object)metricInfo.getName());
                }
            });
            if (null == max) {
                return C.list((List)list).sorted(comp);
            }
            return C.list((List)list).take(max.intValue()).sorted(comp);
        }
        MetricInfoTree tree = new MetricInfoTree((List<MetricInfo>)list, (Lang.Predicate<String>)theFilter);
        return tree.root(decorator);
    }
}

