/*
 * Decompiled with CFR 0.152.
 */
package act.metric;

import act.app.AppByteCodeScannerBase;
import act.asm.AnnotationVisitor;
import act.asm.Type;
import act.metric.MetricContext;
import act.metric.MetricMetaInfoRepo;
import act.util.ByteCodeVisitor;

public class MetricContextScanner
extends AppByteCodeScannerBase {
    private static final String DESC_METRIC_CONTEXT = Type.getType(MetricContext.class).getDescriptor();
    private MetricMetaInfoRepo repo;

    @Override
    protected void onAppSet() {
        this.repo = this.app().metricMetaInfoRepo();
    }

    @Override
    protected boolean shouldScan(String className) {
        return true;
    }

    @Override
    public ByteCodeVisitor byteCodeVisitor() {
        return new ByteCodeVisitor(){
            private String className;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                this.className = Type.getObjectType((String)name).getClassName();
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(desc, visible);
                if (DESC_METRIC_CONTEXT.equals(desc)) {
                    return new AnnotationVisitor(327680, av){

                        public void visit(String name, Object value) {
                            super.visit(name, value);
                            if ("value".equals(name)) {
                                MetricContextScanner.this.repo.registerMetricContext(className, value.toString());
                            }
                        }
                    };
                }
                return av;
            }
        };
    }

    @Override
    public void scanFinished(String className) {
    }
}

