/*
 * Decompiled with CFR 0.152.
 */
package act.metric;

import act.app.App;
import act.asm.AnnotationVisitor;
import act.asm.ClassVisitor;
import act.asm.Label;
import act.asm.MethodVisitor;
import act.asm.Type;
import act.asm.commons.AdviceAdapter;
import act.metric.MeasureCount;
import act.metric.MeasureTime;
import act.metric.Metric;
import act.metric.MetricMetaInfoRepo;
import act.metric.Timer;
import act.util.AppByteCodeEnhancer;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.S;

public class MetricEnhancer
extends AppByteCodeEnhancer<MetricEnhancer> {
    private static final String DESC_MEASURE_TIME = Type.getType(MeasureTime.class).getDescriptor();
    private static final String DESC_MEASURE_COUNT = Type.getType(MeasureCount.class).getDescriptor();
    private static final Type TYPE_METRIC = Type.getType(Metric.class);
    private static final Type TYPE_TIMER = Type.getType(Timer.class);
    private String className;
    private MetricMetaInfoRepo repo;

    public MetricEnhancer() {
        super((Lang.Predicate<String>)S.F.startsWith((String)"act.").negate());
    }

    MetricEnhancer(MetricMetaInfoRepo repo, ClassVisitor cv) {
        super((Lang.Predicate<String>)S.F.startsWith((String)"act.").negate(), cv);
        this.repo = (MetricMetaInfoRepo)$.notNull((Object)repo);
    }

    public MetricEnhancer(ClassVisitor cv) {
        super((Lang.Predicate<String>)S.F.startsWith((String)"act.").negate(), cv);
    }

    @Override
    public AppByteCodeEnhancer app(App app) {
        this.repo = app.metricMetaInfoRepo();
        return super.app(app);
    }

    @Override
    protected Class<MetricEnhancer> subClass() {
        return MetricEnhancer.class;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = Type.getObjectType((String)name).getClassName();
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        final String methodName = name;
        return new AdviceAdapter(327680, mv, access, name, desc){
            private String timeLabel;
            private String countLabel;
            private int posMetric;
            private int posTimer;
            private Label startFinally;
            {
                super(x0, x1, x2, x3, x4);
                this.startFinally = new Label();
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                AnnotationVisitor av = super.visitAnnotation(desc, visible);
                if (DESC_MEASURE_TIME.equals(desc)) {
                    this.timeLabel = methodName;
                    return new AnnotationVisitor(327680, av){

                        public void visit(String name, Object value) {
                            super.visit(name, value);
                            if ("value".equals(name)) {
                                timeLabel = S.string((Object)value);
                            }
                        }
                    };
                }
                if (DESC_MEASURE_COUNT.equals(desc)) {
                    this.countLabel = methodName;
                    return new AnnotationVisitor(327680, av){

                        public void visit(String name, Object value) {
                            super.visit(name, value);
                            if ("value".equals(name)) {
                                countLabel = S.string((Object)value);
                            }
                        }
                    };
                }
                return av;
            }

            public void visitCode() {
                super.visitCode();
                if (null != this.timeLabel) {
                    this.mv.visitLabel(this.startFinally);
                }
            }

            public void visitMaxs(int maxStack, int maxLocals) {
                if (null != this.timeLabel) {
                    Label endFinally = new Label();
                    this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
                    this.mv.visitLabel(endFinally);
                    this.onFinally(191);
                    this.mv.visitInsn(191);
                    this.mv.visitMaxs(maxStack, maxLocals);
                } else {
                    super.visitMaxs(maxStack, maxLocals);
                }
            }

            protected void onMethodEnter() {
                if (null == this.timeLabel && null == this.countLabel) {
                    return;
                }
                this.posMetric = this.newLocal(TYPE_METRIC);
                this.mv.visitMethodInsn(184, "act/Act", "metricPlugin", "()Lact/metric/MetricPlugin;", false);
                String context = MetricEnhancer.this.repo.contextOfClass(MetricEnhancer.this.className);
                this.mv.visitLdcInsn((Object)"app");
                this.mv.visitMethodInsn(185, "act/metric/MetricPlugin", "metric", "(Ljava/lang/String;)Lact/metric/Metric;", true);
                this.mv.visitVarInsn(58, this.posMetric);
                if (null != this.countLabel && !this.countLabel.equalsIgnoreCase(this.timeLabel)) {
                    this.mv.visitVarInsn(25, this.posMetric);
                    this.mv.visitLdcInsn((Object)MetricMetaInfoRepo.concat(context, this.countLabel));
                    this.mv.visitMethodInsn(185, "act/metric/Metric", "countOnce", "(Ljava/lang/String;)V", true);
                }
                if (null != this.timeLabel) {
                    this.posTimer = this.newLocal(TYPE_TIMER);
                    this.mv.visitVarInsn(25, this.posMetric);
                    this.mv.visitLdcInsn((Object)MetricMetaInfoRepo.concat(context, this.timeLabel));
                    this.mv.visitMethodInsn(185, "act/metric/Metric", "startTimer", "(Ljava/lang/String;)Lact/metric/Timer;", true);
                    this.mv.visitVarInsn(58, this.posTimer);
                }
            }

            protected final void onMethodExit(int opcode) {
                if (null == this.timeLabel) {
                    return;
                }
                if (opcode != 191) {
                    this.onFinally(opcode);
                }
            }

            private void onFinally(int opcode) {
                this.mv.visitVarInsn(25, this.posTimer);
                this.mv.visitMethodInsn(185, "act/metric/Timer", "close", "()V", true);
            }
        };
    }
}

