/*
 * Decompiled with CFR 0.152.
 */
package act.metric;

import act.app.App;
import act.app.AppServiceBase;
import act.app.event.SysEventId;
import act.util.ClassInfoRepository;
import act.util.ClassNode;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.osgl.util.S;

public class MetricMetaInfoRepo
extends AppServiceBase<MetricMetaInfoRepo> {
    private Map<String, String> contexts = new HashMap<String, String>();

    public MetricMetaInfoRepo(final App app) {
        super(app);
        app.jobManager().on(SysEventId.APP_CODE_SCANNED, new Runnable(){

            @Override
            public void run() {
                MetricMetaInfoRepo.this.mergeFromParents(app.classLoader().classInfoRepository());
            }
        });
    }

    @Override
    protected void releaseResources() {
        this.contexts.clear();
    }

    public void registerMetricContext(String className, String context) {
        this.contexts.put(className, context);
    }

    public String contextOfClass(String className) {
        return this.contexts.get(className);
    }

    private void mergeFromParents(ClassInfoRepository classInfoRepository) {
        TreeSet<String> sortedClassNames = new TreeSet<String>(classInfoRepository.parentClassFirst);
        sortedClassNames.addAll(this.contexts.keySet());
        for (String className : sortedClassNames) {
            String context = this.contexts.get(className);
            if (context.startsWith("/")) {
                context = MetricMetaInfoRepo.calibrate(context);
            } else {
                ClassNode parentNode;
                ClassNode node = classInfoRepository.node(className);
                if (null != node && null != (parentNode = node.parent())) {
                    String parentContext = this.contexts.get(parentNode.name());
                    context = MetricMetaInfoRepo.concat(parentContext, context);
                }
            }
            this.contexts.put(className, context);
        }
    }

    private static String calibrate(String context) {
        while (context.startsWith("/")) {
            context = context.substring(1);
        }
        return context.replace('/', ':');
    }

    public static String concat(String parent, String child) {
        return child.startsWith("/") || S.blank((String)parent) ? MetricMetaInfoRepo.calibrate(child) : MetricMetaInfoRepo.calibrate(S.pathConcat((String)parent, (char)':', (String)child));
    }
}

