/*
 * Decompiled with CFR 0.152.
 */
package act.plugin;

import act.app.ActionContext;
import act.controller.meta.ControllerClassMetaInfo;
import act.plugin.Plugin;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.http.H;
import org.osgl.mvc.result.Result;
import org.osgl.util.C;

public abstract class ControllerPlugin
implements Plugin {
    private static final Lang.Func2<Result, ActionContext, Result> DUMB_AFTER_HANDLER = new Lang.F2<Result, ActionContext, Result>(){

        public Result apply(Result result, ActionContext context) throws NotAppliedException, Lang.Break {
            return result;
        }
    };

    protected abstract Map<Class<? extends Annotation>, H.Method> annotationMethodLookup();

    protected abstract PathAnnotationSpec urlContextAnnotation();

    protected abstract boolean noDefaultPath();

    public Lang.Function<ActionContext, Result> beforeHandler(Class<?> controllerClass, Method actionMethod) {
        return $.f1();
    }

    public Lang.Func2<Result, ActionContext, Result> afterHandler(Class<?> controllerClass, Method actionMethod) {
        return DUMB_AFTER_HANDLER;
    }

    @Override
    public void register() {
        ControllerClassMetaInfo.registerMethodLookups(this.annotationMethodLookup(), this.noDefaultPath());
        ControllerClassMetaInfo.registerUrlContextAnnotation(this.urlContextAnnotation());
        Manager.INST.controllerPlugins.add(this);
    }

    public static class Manager
    extends ControllerPlugin {
        public static final Manager INST = new Manager();
        private List<ControllerPlugin> controllerPlugins = new ArrayList<ControllerPlugin>();

        @Override
        public Lang.Function<ActionContext, Result> beforeHandler(final Class<?> controllerClass, final Method actionMethod) {
            int size = this.controllerPlugins.size();
            switch (size) {
                case 0: {
                    return super.beforeHandler(controllerClass, actionMethod);
                }
                case 1: {
                    return this.controllerPlugins.get(0).beforeHandler(controllerClass, actionMethod);
                }
            }
            return new Lang.Function<ActionContext, Result>(){

                public Result apply(ActionContext context) throws NotAppliedException, Lang.Break {
                    for (ControllerPlugin plugin : Manager.this.controllerPlugins) {
                        Result result = (Result)((Object)plugin.beforeHandler(controllerClass, actionMethod).apply((Object)context));
                        if (null == result) continue;
                        return result;
                    }
                    return null;
                }
            };
        }

        @Override
        public Lang.Func2<Result, ActionContext, Result> afterHandler(final Class<?> controllerClass, final Method actionMethod) {
            int size = this.controllerPlugins.size();
            switch (size) {
                case 0: {
                    return super.afterHandler(controllerClass, actionMethod);
                }
                case 1: {
                    return this.controllerPlugins.get(0).afterHandler(controllerClass, actionMethod);
                }
            }
            return new Lang.Func2<Result, ActionContext, Result>(){

                public Result apply(Result result, ActionContext context) throws NotAppliedException, Lang.Break {
                    for (ControllerPlugin plugin : Manager.this.controllerPlugins) {
                        result = (Result)((Object)plugin.afterHandler(controllerClass, actionMethod).apply((Object)result, (Object)context));
                    }
                    return result;
                }
            };
        }

        @Override
        protected Map<Class<? extends Annotation>, H.Method> annotationMethodLookup() {
            return C.Map((Object[])new Object[0]);
        }

        @Override
        protected PathAnnotationSpec urlContextAnnotation() {
            return null;
        }

        @Override
        protected boolean noDefaultPath() {
            return false;
        }

        @Override
        public void register() {
        }
    }

    public static final class PathAnnotationSpec {
        private final Class<? extends Annotation> annoType;
        private final boolean supportAbsolutePath;
        private final boolean supportInheritance;

        public PathAnnotationSpec(Class<? extends Annotation> annoType, boolean supportAbsolutePath, boolean supportInheritance) {
            this.annoType = annoType;
            this.supportAbsolutePath = supportAbsolutePath;
            this.supportInheritance = supportInheritance;
        }

        public Class<? extends Annotation> annoType() {
            return this.annoType;
        }

        public boolean supportAbsolutePath() {
            return this.supportAbsolutePath;
        }

        public boolean supportInheritance() {
            return this.supportInheritance;
        }
    }
}

