/*
 * Decompiled with CFR 0.152.
 */
package act.route;

import act.Act;
import act.route.RouteSource;
import act.route.Router;
import act.route.RouterBuilder;
import java.util.Iterator;
import java.util.List;
import org.osgl.http.H;
import org.osgl.http.util.Path;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;
import org.osgl.util.Unsafe;

public class RouteTableRouterBuilder
implements RouterBuilder {
    public static final String ROUTES_FILE = "routes.conf";
    private List<String> lines;

    public RouteTableRouterBuilder(List<String> lines) {
        E.NPE(lines);
        this.lines = lines;
    }

    public RouteTableRouterBuilder(String ... lines) {
        E.illegalArgumentIf((lines.length == 0 ? 1 : 0) != 0, (String)"Empty route configuration file lines");
        this.lines = C.listOf((Object[])lines);
    }

    @Override
    public void build(Router router) {
        int lineNo = this.lines.size();
        for (int i = 0; i < lineNo; ++i) {
            String line = this.lines.get(i).trim();
            if (line.startsWith("#") || S.blank((String)line)) continue;
            try {
                this.process(line, router);
                continue;
            }
            catch (RuntimeException e) {
                if (Act.isDev()) {
                    router.app().setBlockIssue(e);
                    continue;
                }
                throw e;
            }
        }
    }

    private void process(String line, Router router) {
        Iterator itr = Path.tokenizer((char[])Unsafe.bufOf((String)line), (int)0, (char)' ', (char)'\u0000');
        String UNKNOWN = S.fmt((String)"route configuration not recognized: %s", (Object[])new Object[]{line});
        CharSequence method = null;
        CharSequence path = null;
        S.Buffer action = S.newBuffer();
        if (itr.hasNext()) {
            method = (CharSequence)itr.next();
        } else {
            E.illegalArgumentIf((boolean)true, (String)UNKNOWN);
        }
        if (itr.hasNext()) {
            path = (CharSequence)itr.next();
        } else {
            E.illegalArgumentIf((boolean)true, (String)UNKNOWN);
        }
        E.illegalArgumentIf((!itr.hasNext() ? 1 : 0) != 0, (String)UNKNOWN);
        action.append((CharSequence)itr.next());
        while (itr.hasNext()) {
            action.append(" ").append((CharSequence)itr.next());
        }
        if ("*".contentEquals(method)) {
            for (H.Method m : Router.supportedHttpMethods()) {
                router.addMapping(m, path, (CharSequence)action, RouteSource.ROUTE_TABLE);
            }
        } else {
            String s = method.toString();
            if ("context".equalsIgnoreCase(s) || "ctx".equalsIgnoreCase(s)) {
                router.addContext(action.toString(), path.toString());
            } else {
                H.Method m = H.Method.valueOfIgnoreCase((String)s);
                router.addMapping(m, path, (CharSequence)action, RouteSource.ROUTE_TABLE);
            }
        }
    }
}

