/*
 * Decompiled with CFR 0.152.
 */
package act.route;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgl.util.S;

public class UrlPath {
    static final String DYNA_PART = "";
    private final List<String> parts = new ArrayList<String>();
    private static Map<String, UrlPath> paths = new HashMap<String, UrlPath>();

    private UrlPath(CharSequence path) {
        String[] sa;
        String s = path.toString();
        for (String item : sa = s.split("/")) {
            if (!S.notBlank((String)item)) continue;
            if (item.startsWith("{") || item.contains(":")) {
                item = DYNA_PART;
            }
            this.parts.add(item);
        }
    }

    public int size() {
        return this.parts.size();
    }

    public String part(int index) {
        return this.parts.get(index);
    }

    public String lastPart() {
        return this.part(this.size() - 1);
    }

    public boolean isBuiltIn() {
        return !this.parts.isEmpty() && "~".equals(this.parts.get(0));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UrlPath) {
            UrlPath that = (UrlPath)obj;
            if (this.parts.size() != that.parts.size()) {
                return false;
            }
            for (int i = this.parts.size() - 1; i >= 0; --i) {
                if (UrlPath.matches(this.parts.get(i), that.parts.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static UrlPath of(CharSequence path) {
        UrlPath urlPath = paths.get(path.toString());
        if (null == urlPath) {
            urlPath = new UrlPath(path);
            paths.put(path.toString(), urlPath);
        }
        return urlPath;
    }

    private static boolean matches(CharSequence cs1, CharSequence cs2) {
        if (DYNA_PART.equals(cs1)) {
            return true;
        }
        int len = cs1.length();
        if (len != cs2.length()) {
            return false;
        }
        for (int i = len - 1; i >= 0; --i) {
            if (cs1.charAt(i) == cs2.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

