/*
 * Decompiled with CFR 0.152.
 */
package act.session;

import act.conf.AppConfig;
import act.session.DefaultSessionCodec;
import act.session.JWT;
import act.session.SessionCodec;
import act.util.Lazy;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.osgl.$;
import org.osgl.http.H;
import org.osgl.util.S;

@Singleton
@Lazy
public class JsonWebTokenSessionCodec
implements SessionCodec {
    private JWT jwt;
    private final boolean sessionWillExpire;
    private final int ttlInMillis;
    private final String pingPath;

    @Inject
    public JsonWebTokenSessionCodec(AppConfig conf, JWT jwt) {
        this.ttlInMillis = conf.sessionTtl() * 1000;
        this.sessionWillExpire = this.ttlInMillis > 0;
        this.pingPath = conf.pingPath();
        this.jwt = (JWT)$.notNull((Object)jwt);
    }

    @Override
    public String encodeSession(H.Session session) {
        if (null == session) {
            return null;
        }
        boolean sessionChanged = session.changed();
        if (!(sessionChanged || !session.empty() && this.sessionWillExpire)) {
            return null;
        }
        session.id();
        if (this.sessionWillExpire && !session.contains("___TS")) {
            session.put("___TS", (Object)($.ms() + (long)this.ttlInMillis));
        }
        return this.populateToken(this.jwt.newToken(), (H.KV<?>)session).toString(this.jwt);
    }

    @Override
    public String encodeFlash(H.Flash flash) {
        if (null == flash || flash.isEmpty()) {
            return null;
        }
        return this.populateToken(this.jwt.newToken(), (H.KV<?>)flash).toString(this.jwt);
    }

    @Override
    public H.Session decodeSession(String encodedSession, H.Request request) {
        H.Session session = new H.Session();
        boolean newSession = true;
        if (S.notBlank((String)encodedSession)) {
            this.resolveFromJwtToken((H.KV<?>)session, encodedSession, true);
            newSession = false;
        }
        DefaultSessionCodec.processExpiration(session, $.ms(), newSession, this.sessionWillExpire, this.ttlInMillis, this.pingPath, request);
        return session;
    }

    @Override
    public H.Flash decodeFlash(String encodedFlash) {
        H.Flash flash = new H.Flash();
        if (S.notBlank((String)encodedFlash)) {
            this.resolveFromJwtToken((H.KV<?>)flash, encodedFlash, false);
            flash.discard();
        }
        return flash;
    }

    private JWT.Token populateToken(JWT.Token token, H.KV<?> state) {
        for (Map.Entry entry : state.entrySet()) {
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            if ("___TS".equals(k)) {
                long l = Long.parseLong(v);
                token.payload(JWT.Payload.EXPIRES_AT, (Object)(l / 1000L));
                continue;
            }
            if ("___ID".equals(k)) continue;
            token.payload(k, (Object)v);
        }
        return token;
    }

    private void resolveFromJwtToken(H.KV<?> state, String tokenString, boolean isSession) {
        JWT.Token token = this.jwt.deserialize(tokenString);
        if (null == token) {
            return;
        }
        for (Map.Entry<String, Object> entry : token.payloads().entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (isSession && "jti".equals(key)) {
                state.put("___ID", val);
                continue;
            }
            if (JWT.Payload.EXPIRES_AT.key().equals(key) || JWT.Payload.ISSUER.key().equals(key)) continue;
            state.put(key, val);
        }
    }
}

