/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.Destroyable;
import act.act_messages;
import act.app.ActionContext;
import act.app.App;
import act.cli.CliContext;
import act.conf.AppConfig;
import act.i18n.I18n;
import act.mail.MailerContext;
import act.util.DestroyableBase;
import act.util.ProgressGauge;
import act.util.SimpleProgressGauge;
import act.view.Template;
import act.view.ViewManager;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.validation.ConstraintViolation;
import org.osgl.$;
import org.osgl.http.H;
import org.osgl.mvc.util.ParamValueProvider;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public interface ActContext<CTX_TYPE extends ActContext>
extends ParamValueProvider {
    public App app();

    public AppConfig config();

    public CTX_TYPE accept(H.Format var1);

    public H.Format accept();

    public CTX_TYPE locale(Locale var1);

    public Locale locale();

    public Locale locale(boolean var1);

    public String templatePath();

    public String templateContent();

    public CTX_TYPE templatePath(String var1);

    public CTX_TYPE templateContent(String var1);

    public String templateContext();

    public CTX_TYPE templateContext(String var1);

    public boolean templatePathIsImplicit();

    public Template cachedTemplate();

    public CTX_TYPE cacheTemplate(Template var1);

    public <T> T renderArg(String var1);

    public Map<String, Object> renderArgs();

    public CTX_TYPE renderArg(String var1, Object var2);

    public CTX_TYPE addListener(Listener var1);

    public CTX_TYPE addDestroyable(Destroyable var1);

    public CTX_TYPE attribute(String var1, Object var2);

    public <T> T attribute(String var1);

    public Map<String, Object> attributes();

    public CTX_TYPE removeAttribute(String var1);

    public CTX_TYPE addViolations(Map<String, ConstraintViolation> var1);

    public CTX_TYPE addViolation(String var1, ConstraintViolation var2);

    public boolean hasViolation();

    public Map<String, ConstraintViolation> violations();

    public ConstraintViolation violation(String var1);

    public String sessionId();

    @Deprecated
    public String pattern();

    @Deprecated
    public CTX_TYPE pattern(String var1);

    public String _act_i18n(String var1, Object ... var2);

    public String i18n(boolean var1, String var2, Object ... var3);

    public String i18n(String var1, Object ... var2);

    public String i18n(Class<?> var1, String var2, Object ... var3);

    public String i18n(boolean var1, Class<?> var2, String var3, Object ... var4);

    public String i18n(Enum<?> var1);

    public String i18n(Class<?> var1, Enum<?> var2);

    public Map<String, Object> i18n(Class<? extends Enum> var1);

    public Map<String, Object> i18n(Class<?> var1, Class<? extends Enum> var2);

    public Map<String, Object> i18n(Class<? extends Enum> var1, boolean var2);

    public Map<String, Object> i18n(Class<?> var1, Class<? extends Enum> var2, boolean var3);

    public String methodPath();

    public Method handlerMethod();

    public CTX_TYPE handlerMethod(Method var1);

    public Method currentMethod();

    public CTX_TYPE currentMethod(Method var1);

    public CTX_TYPE fastjsonFilters(Class<? extends SerializeFilter>[] var1);

    public SerializeFilter[] fastjsonFilters();

    public CTX_TYPE fastjsonFeatures(SerializerFeature[] var1);

    public SerializerFeature[] fastjsonFeatures();

    public CTX_TYPE dateFormatPattern(String var1);

    public String dateFormatPattern();

    public S.Buffer strBuf();

    public static abstract class Base<CTX extends Base>
    extends DestroyableBase
    implements ActContext<CTX> {
        private App app;
        private String templatePath;
        private String templateContent;
        private String templateContext;
        private Template template;
        private Map<String, Object> renderArgs;
        private List<Listener> listenerList;
        private List<Destroyable> destroyableList;
        private Map<String, Object> attributes;
        private Locale locale;
        private int fieldOutputVarCount;
        private S.Buffer strBuf;
        private boolean noTemplateCache;
        private volatile SimpleProgressGauge progress;
        private String jobId;
        private Method handlerMethod;
        private Method currentMethod;
        private String pattern;
        private Map<String, ConstraintViolation> violations;
        private Class<? extends SerializeFilter>[] fastjsonFilters;
        private SerializerFeature[] fastjsonFeatures;
        private String dateFormatPattern;

        public Base(App app) {
            this(app, false);
        }

        protected Base(App app, boolean noLogger) {
            super(noLogger);
            E.NPE((Object)app);
            this.app = app;
            this.renderArgs = new HashMap<String, Object>();
            this.attributes = new HashMap<String, Object>();
            this.listenerList = new ArrayList<Listener>();
            this.destroyableList = new ArrayList<Destroyable>();
            this.strBuf = S.newSizedBuffer((int)app.config().strBufRetentionLimit());
            this.violations = new HashMap<String, ConstraintViolation>();
        }

        @Override
        protected void releaseResources() {
            for (Listener l : this.listenerList) {
                try {
                    l.onDestroy(this);
                }
                catch (Exception e) {
                    this.warn(e, "error calling listener onDestroy method", new Object[0]);
                }
            }
            Destroyable.Util.destroyAll(this.destroyableList, RequestScoped.class);
            Destroyable.Util.tryDestroyAll(this.attributes.values(), RequestScoped.class);
            this.attributes.clear();
            this.renderArgs.clear();
            this.template = null;
            this.app = null;
            this.template = null;
            this.listenerList.clear();
            this.destroyableList.clear();
            this.violations.clear();
        }

        @Override
        public App app() {
            return this.app;
        }

        @Override
        public AppConfig config() {
            return this.app().config();
        }

        @Override
        public Method handlerMethod() {
            return this.handlerMethod;
        }

        @Override
        public CTX handlerMethod(Method method) {
            this.handlerMethod = method;
            return this.me();
        }

        @Override
        public Method currentMethod() {
            return this.currentMethod;
        }

        @Override
        public CTX currentMethod(Method method) {
            this.currentMethod = method;
            return this.me();
        }

        @Override
        public CTX fastjsonFilters(Class<? extends SerializeFilter>[] filters) {
            this.fastjsonFilters = filters;
            return this.me();
        }

        @Override
        public SerializeFilter[] fastjsonFilters() {
            if (null == this.fastjsonFilters) {
                return null;
            }
            int len = this.fastjsonFilters.length;
            SerializeFilter[] filters = new SerializeFilter[len];
            for (int i = 0; i < len; ++i) {
                filters[i] = this.app().getInstance(this.fastjsonFilters[i]);
            }
            return filters;
        }

        @Override
        public CTX fastjsonFeatures(SerializerFeature[] features) {
            this.fastjsonFeatures = features;
            return this.me();
        }

        @Override
        public SerializerFeature[] fastjsonFeatures() {
            return this.fastjsonFeatures;
        }

        @Override
        public CTX dateFormatPattern(String pattern) {
            this.dateFormatPattern = pattern;
            return this.me();
        }

        @Override
        public String dateFormatPattern() {
            return this.dateFormatPattern;
        }

        @Override
        public String templatePath() {
            String path = this.templatePath;
            String context = this.templateContext;
            if (S.notBlank((String)path)) {
                return path.startsWith("/") || S.blank((String)context) ? path : S.pathConcat((String)context, (char)'/', (String)path);
            }
            if (S.blank((String)context)) {
                return this.methodPath().replace('.', '/');
            }
            return S.pathConcat((String)context, (char)'/', (String)S.afterLast((String)this.methodPath(), (String)"."));
        }

        @Override
        public CTX templatePath(String templatePath) {
            this.template = null;
            this.templateContent = null;
            this.templatePath = templatePath;
            return this.me();
        }

        @Override
        public String templateContent() {
            return this.templateContent;
        }

        @Override
        public CTX templateContent(String content) {
            this.template = null;
            this.templateContent = content;
            return this.me();
        }

        public CTX templateLiteral(String literal) {
            if (S.empty((String)literal)) {
                return this.me();
            }
            return (CTX)(ViewManager.isTemplatePath(literal) ? this.templatePath(literal) : this.templateContent(literal));
        }

        @Override
        public String templateContext() {
            return this.templateContext;
        }

        @Override
        public CTX templateContext(String templateContext) {
            this.template = null;
            this.templateContext = templateContext;
            return this.me();
        }

        @Override
        public boolean templatePathIsImplicit() {
            return null == this.templatePath;
        }

        @Override
        public Template cachedTemplate() {
            return this.template;
        }

        public CTX disableTemplateCaching() {
            this.noTemplateCache = true;
            return this.me();
        }

        @Override
        public CTX cacheTemplate(Template template) {
            if (!this.noTemplateCache) {
                this.template = template;
            }
            return this.me();
        }

        @Override
        public String pattern() {
            return this.pattern;
        }

        @Override
        public CTX pattern(String pattern) {
            this.pattern = pattern;
            return this.me();
        }

        @Override
        public String sessionId() {
            return null;
        }

        @Override
        public final CTX locale(Locale locale) {
            this.locale = locale;
            return this.me();
        }

        @Override
        public final Locale locale() {
            return this.locale;
        }

        @Override
        public Locale locale(boolean required) {
            Locale locale = this.locale;
            if (null == locale) {
                if (!required) {
                    return null;
                }
                locale = this.config().locale();
            }
            return locale;
        }

        @Override
        public String i18n(boolean ignoreError, String msgId, Object ... args) {
            return I18n.i18n(ignoreError, this.locale(true), msgId, args);
        }

        @Override
        public String i18n(String msgId, Object ... args) {
            return I18n.i18n(this.locale(true), msgId, args);
        }

        @Override
        public String _act_i18n(String msgId, Object ... args) {
            return I18n.i18n(this.locale(true), act_messages.class, msgId, args);
        }

        @Override
        public String i18n(Class<?> bundleSpec, String msgId, Object ... args) {
            return I18n.i18n(this.locale(true), bundleSpec, msgId, args);
        }

        @Override
        public String i18n(boolean ignoreError, Class<?> bundleSpec, String msgId, Object ... args) {
            return I18n.i18n(ignoreError, this.locale(true), bundleSpec, msgId, args);
        }

        @Override
        public String i18n(Enum<?> msgId) {
            return I18n.i18n(this.locale(true), msgId);
        }

        @Override
        public String i18n(Class<?> bundleSpec, Enum<?> msgId) {
            return I18n.i18n(this.locale(true), bundleSpec, msgId);
        }

        @Override
        public Map<String, Object> i18n(Class<? extends Enum> enumClass) {
            return I18n.i18n(this.locale(true), enumClass);
        }

        @Override
        public Map<String, Object> i18n(Class<?> bundleSpec, Class<? extends Enum> enumClass) {
            return I18n.i18n(this.locale(true), bundleSpec, enumClass);
        }

        @Override
        public Map<String, Object> i18n(Class<? extends Enum> enumClass, boolean outputPropeties) {
            return I18n.i18n(this.locale(true), enumClass, outputPropeties);
        }

        @Override
        public Map<String, Object> i18n(Class<?> bundleSpec, Class<? extends Enum> enumClass, boolean outputProperties) {
            return I18n.i18n(this.locale(true), bundleSpec, enumClass, outputProperties);
        }

        protected CTX me() {
            return (CTX)this;
        }

        @Override
        public <T> T renderArg(String name) {
            return (T)this.renderArgs.get(name);
        }

        @Override
        public CTX renderArg(String name, Object val) {
            this.renderArgs.put(name, val);
            return this.me();
        }

        public CTX fieldOutputVarCount(int count) {
            this.fieldOutputVarCount = count;
            return this.me();
        }

        public int fieldOutputVarCount() {
            return this.fieldOutputVarCount;
        }

        @Override
        public Map<String, Object> renderArgs() {
            return this.renderArgs;
        }

        protected boolean hasRenderArgs() {
            return !this.renderArgs.isEmpty();
        }

        @Override
        public CTX attribute(String name, Object attr) {
            this.attributes.put(name, attr);
            return this.me();
        }

        @Override
        public <T> T attribute(String name) {
            return (T)$.cast((Object)this.attributes.get(name));
        }

        @Override
        public CTX removeAttribute(String name) {
            this.attributes.remove(name);
            return this.me();
        }

        @Override
        public Map<String, Object> attributes() {
            return this.attributes;
        }

        @Override
        public CTX addListener(Listener listener) {
            this.listenerList.add(listener);
            return this.me();
        }

        @Override
        public CTX addDestroyable(Destroyable resource) {
            this.destroyableList.add(resource);
            return this.me();
        }

        @Override
        public S.Buffer strBuf() {
            return this.strBuf.consumed() ? this.strBuf.reset() : S.newBuffer();
        }

        @Override
        public CTX addViolations(Map<String, ConstraintViolation> violations) {
            this.violations.putAll(violations);
            return this.me();
        }

        @Override
        public CTX addViolation(String property, ConstraintViolation violation) {
            this.violations.put(property, violation);
            return this.me();
        }

        @Override
        public boolean hasViolation() {
            return !this.violations.isEmpty();
        }

        @Override
        public Map<String, ConstraintViolation> violations() {
            return C.map(this.violations);
        }

        @Override
        public ConstraintViolation violation(String property) {
            return this.violations.get(property);
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
            this.app().jobManager().setJobProgressGauge(jobId, this.progress());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProgressGauge progress() {
            if (null == this.progress) {
                Base base = this;
                synchronized (base) {
                    if (null == this.progress) {
                        this.progress = new SimpleProgressGauge();
                    }
                }
            }
            return this.progress;
        }

        public static Base<?> currentContext() {
            Base ctx = ActionContext.current();
            if (null != ctx) {
                return ctx;
            }
            ctx = CliContext.current();
            if (null != ctx) {
                return ctx;
            }
            ctx = MailerContext.current();
            if (null != ctx) {
                return ctx;
            }
            return null;
        }

        public static Class<? extends ActContext> currentContextType() {
            Base<?> ctx = Base.currentContext();
            return null == ctx ? null : ctx.getClass();
        }

        public static String currentDateFormatPattern() {
            Base<?> current = Base.currentContext();
            return null == current ? null : current.dateFormatPattern();
        }
    }

    public static interface Listener {
        public void onDestroy(ActContext var1);
    }
}

