/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.Act;
import act.app.ActionContext;
import act.app.App;
import act.app.DevModeClassLoader;
import act.app.Source;
import act.app.SourceInfo;
import act.app.SourceInfoImpl;
import act.asm.AsmContext;
import act.cli.CliContext;
import act.handler.DelegateRequestHandler;
import act.handler.RequestHandler;
import act.handler.builtin.controller.ControllerAction;
import act.handler.builtin.controller.RequestHandlerProxy;
import act.handler.builtin.controller.impl.ReflectedHandlerInvoker;
import act.i18n.I18n;
import act.util.ActContext;
import java.lang.annotation.ElementType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.osgl.$;
import org.osgl.http.H;
import org.osgl.mvc.MvcConfig;
import org.osgl.util.E;
import org.osgl.util.S;

public interface ActError {
    public Throwable getCauseOrThis();

    public Throwable getCause();

    public SourceInfo sourceInfo();

    public List<String> stackTrace();

    public String getMessage();

    public String getLocalizedMessage();

    public boolean isErrorSpot(String var1, String var2);

    public static class Util {
        public static String errorMessage(H.Status status) {
            return Util.errorMessage(status, null, new Object[0]);
        }

        public static String errorMessage(H.Status status, String message, Object ... args) {
            if (S.notBlank((String)message)) {
                return S.fmt((String)message, (Object[])args);
            }
            if (Act.isProd()) {
                return MvcConfig.errorMessage((H.Status)status);
            }
            ActionContext ctx = ActionContext.current();
            if (null == ctx) {
                return MvcConfig.errorMessage((H.Status)status);
            }
            RequestHandler handler = ctx.handler();
            if (null == handler) {
                return MvcConfig.errorMessage((H.Status)status);
            }
            if (H.Status.NOT_FOUND == status) {
                return I18n.i18n(Act.class, "e404.null_value_returned", handler);
            }
            return I18n.i18n(Act.class, "error.on_invoking", MvcConfig.errorMessage((H.Status)status), handler);
        }

        public static SourceInfo loadSourceInfo(Throwable cause, Class<? extends ActError> errorClass) {
            return Util._loadSourceInfo(cause.getStackTrace(), errorClass);
        }

        private static SourceInfo _loadSourceInfo(StackTraceElement[] sa, Class<? extends ActError> errorClass) {
            int len = sa.length;
            StackTraceElement[] caller = new StackTraceElement[len - 1];
            System.arraycopy(sa, 1, caller, 0, len - 1);
            ActContext.Base<?> ctx = ActContext.Base.currentContext();
            if (null == ctx) {
                return Util.loadSourceInfo(caller, errorClass);
            }
            if (ctx instanceof ActionContext) {
                ActionContext actionContext = (ActionContext)$.cast(ctx);
                RequestHandler handler = actionContext.handler();
                String actionName = handler.toString();
                for (StackTraceElement element : caller) {
                    if (!actionName.contains(element.getMethodName()) || !actionName.contains(element.getClassName())) continue;
                    return Util.loadSourceInfo(caller, errorClass);
                }
                if (handler instanceof DelegateRequestHandler) {
                    handler = ((DelegateRequestHandler)handler).realHandler();
                }
                if (handler instanceof RequestHandlerProxy) {
                    RequestHandlerProxy proxy = (RequestHandlerProxy)$.cast((Object)handler);
                    ControllerAction action = proxy.actionHandler();
                    ReflectedHandlerInvoker invoker = (ReflectedHandlerInvoker)$.cast((Object)action.invoker());
                    return Util.loadSourceInfo(invoker.method());
                }
                return Util.loadSourceInfo(caller, errorClass);
            }
            if (ctx instanceof CliContext) {
                CliContext cliContext = (CliContext)$.cast(ctx);
                Method method = cliContext.handlerMethod();
                for (StackTraceElement element : caller) {
                    if (!method.getName().equals(element.getMethodName()) || !method.getDeclaringClass().getName().equals(element.getClassName())) continue;
                    return Util.loadSourceInfo(caller, errorClass);
                }
                return Util.loadSourceInfo(method);
            }
            return Util.loadSourceInfo(caller, errorClass);
        }

        public static SourceInfo loadSourceInfo(Class<? extends ActError> errorClass) {
            return Util._loadSourceInfo(new RuntimeException().getStackTrace(), errorClass);
        }

        public static List<String> stackTraceOf(ActError error) {
            Throwable cause = error.getCause();
            ActError root = error;
            if (null == cause) {
                cause = (Throwable)((Object)error);
                root = null;
            }
            return Util.stackTraceOf(cause, root);
        }

        public static List<String> stackTraceOf(Throwable t, ActError root) {
            ArrayList<String> l = new ArrayList<String>();
            while (null != t) {
                StackTraceElement[] a;
                for (StackTraceElement e : a = t.getStackTrace()) {
                    String line = S.concat((String)"at ", (String)e.toString());
                    if (line.contains("org.osgl.util.E.")) continue;
                    if (l.contains(line)) {
                        l.add(line);
                        break;
                    }
                    l.add(line);
                }
                if ((t = t.getCause()) == root) break;
                if (null == t) continue;
                l.add("Caused by " + t.toString());
            }
            return l;
        }

        public static SourceInfo loadSourceInfo(StackTraceElement[] stackTraceElements, Class<? extends ActError> errClz) {
            E.illegalStateIf((boolean)Act.isProd());
            DevModeClassLoader cl = (DevModeClassLoader)App.instance().classLoader();
            String errClzName = errClz.getName();
            for (StackTraceElement stackTraceElement : stackTraceElements) {
                Source source;
                String className;
                int line = stackTraceElement.getLineNumber();
                if (line <= 0 || S.eq((String)(className = stackTraceElement.getClassName()), (String)errClzName) || null == (source = cl.source(className))) continue;
                return new SourceInfoImpl(source, line);
            }
            return null;
        }

        public static SourceInfo loadSourceInfo(Method method) {
            return Util.loadSourceInfo(method.getDeclaringClass().getName(), method.getName(), true, null);
        }

        public static SourceInfo loadSourceInfo(AsmContext asmContext) {
            return Util.loadSourceInfo(asmContext.className(), asmContext.name(), ElementType.METHOD == asmContext.type(), asmContext.lineNo());
        }

        private static SourceInfo loadSourceInfo(String className, String elementName, boolean isMethod, Integer lineNo) {
            String pattern;
            E.illegalStateIf((boolean)Act.isProd());
            DevModeClassLoader cl = (DevModeClassLoader)App.instance().classLoader();
            Source source = cl.source(className);
            if (null == source) {
                return null;
            }
            List<String> lines = source.lines();
            Line candidate = null;
            String string = pattern = isMethod ? S.concat((String)"^\\s*.*", (String)elementName, (String)"\\s*\\(.*") : S.concat((String)"^\\s*.*", (String)elementName, (String)"[^\\(\\{]*");
            if (null != lineNo) {
                return new SourceInfoImpl(source, lineNo);
            }
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                if (!line.matches(pattern)) continue;
                candidate = new Line(line, i + 1);
                if (!candidate.forSure) continue;
                return new SourceInfoImpl(source, candidate.no);
            }
            if (null != candidate) {
                return new SourceInfoImpl(source, candidate.no);
            }
            return new SourceInfoImpl(source, 1);
        }

        private static class Line {
            String line;
            int no;
            boolean forSure;

            Line(String line, int no) {
                this.line = line;
                this.no = no;
                this.forSure = line.contains("public ");
            }
        }
    }
}

