/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.Act;
import act.app.ActionContext;
import act.util.ErrorTemplatePathResolver;
import act.view.Template;
import act.view.ViewManager;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.http.H;
import org.osgl.mvc.ErrorPageRenderer;
import org.osgl.mvc.MvcConfig;
import org.osgl.mvc.result.ErrorResult;
import org.osgl.util.S;

public class ActErrorPageRender
extends ErrorPageRenderer {
    public static final String ARG_ERROR = "_error";
    private volatile Boolean i18n;
    private Map<String, Lang.Var<Template>> templateCache = new HashMap<String, Lang.Var<Template>>();

    protected String renderTemplate(ErrorResult error, H.Format format) {
        ActionContext context = ActionContext.current();
        if (null == context) {
            return null;
        }
        Integer errorCode = error.errorCode();
        int statusCode = error.statusCode();
        this.fixRequestAcceptFormat(context);
        Template t = this.getTemplate(statusCode, context);
        if (null == t) {
            H.Format accept;
            String errorMsg = error.getMessage();
            if (null == errorMsg) {
                errorMsg = MvcConfig.errorMessage((H.Status)error.status());
            }
            if (this.i18n()) {
                String translated = context.i18n(true, errorMsg, new Object[0]);
                if (translated == errorMsg) {
                    translated = context.i18n(true, MvcConfig.class, errorMsg, new Object[0]);
                }
                errorMsg = translated;
            }
            if (H.Format.JSON == (accept = context.accept())) {
                return this.jsonContent(error, errorCode, errorMsg);
            }
            if (H.Format.HTML == accept) {
                String header = S.concat((String)"HTTP/1.1 ", (String)Integer.toString(statusCode), (String)" ", (String)errorMsg);
                return S.concat((String)"<!DOCTYPE html><html><head><meta charset='utf-8'><title>", (String)header, (String)"</title></head><body><h1>", (String)header, (String)"</h1></body></html>");
            }
            if (H.Format.XML == accept) {
                S.Buffer sb = context.strBuf();
                sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><error>");
                if (null != errorCode) {
                    sb.append("<code>").append((Object)errorCode).append("</code");
                }
                sb.append("<message>").append(errorMsg).append("</message></error>");
                return sb.toString();
            }
            if (H.Format.CSV == accept) {
                if (null == errorCode) {
                    return S.concat((String)"message\n", (String)errorMsg);
                }
                return S.concat((String)"code,message\n", (String)Integer.toString(errorCode), (String)",", (String)errorMsg);
            }
            if (H.Format.TXT == accept) {
                return null == errorCode ? errorMsg : S.concat((String)Integer.toString(errorCode), (String)" ", (String)errorMsg);
            }
            return "";
        }
        if (H.Format.HTML == context.accept()) {
            String header = S.concat((String)"HTTP/1.1 ", (String)Integer.toString(statusCode), (String)" ", (String)MvcConfig.errorMessage((H.Status)error.status()));
            context.renderArg("header", header);
        }
        context.renderArg(ARG_ERROR, error);
        return t.render(context);
    }

    private void fixRequestAcceptFormat(ActionContext context) {
        H.Request req = context.req();
        if (null != req && !this.isAcceptGoodForErrorPage(req.accept())) {
            req.accept(H.Format.HTML);
        }
    }

    private boolean isAcceptGoodForErrorPage(H.Format fmt) {
        return null == fmt || H.Format.HTML == fmt || H.Format.CSV == fmt || H.Format.JSON == fmt || H.Format.XML == fmt;
    }

    private String jsonContent(ErrorResult error, Integer errorCode, String errorMsg) {
        Object payload = error.attachment();
        if (null != payload) {
            return JSON.toJSONString((Object)payload);
        }
        if (null == errorCode) {
            return S.concat((Object)"{\"ts\":", (Object)$.ms(), (Object)",\"message\":\"", (Object)errorMsg, (Object)"\"}");
        }
        return S.concat((Object)"{\"ts\":", (Object)$.ms(), (Object)",\"code\":", (Object)S.string((Object)errorCode), (Object)",\"message\":\"", (Object[])new Object[]{errorMsg, "\"}"});
    }

    private String templatePath(int code, ActionContext context) {
        ErrorTemplatePathResolver resolver = context.config().errorTemplatePathResolver();
        if (null == resolver) {
            resolver = new ErrorTemplatePathResolver.DefaultErrorTemplatePathResolver();
        }
        return resolver.resolve(code, context.accept());
    }

    private Template getTemplate(int statusCode, ActionContext context) {
        H.Format format = context.accept();
        String key = statusCode + "" + format;
        Lang.Var templateBag = this.templateCache.get(key);
        if (null == templateBag) {
            ViewManager vm = Act.viewManager();
            if (null == vm) {
                return null;
            }
            context.templatePath(this.templatePath(statusCode, context));
            Template t = vm.load(context);
            if (null == t) {
                if (Act.isDev()) {
                    context.templatePath("/error/dev/errorPage." + context.accept().name());
                } else {
                    context.templatePath("/error/errorPage." + context.accept().name());
                }
                t = vm.load(context);
            }
            templateBag = $.var((Object)t);
            this.templateCache.put(key, (Lang.Var<Template>)templateBag);
        }
        return (Template)templateBag.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean i18n() {
        if (null == this.i18n) {
            ActErrorPageRender actErrorPageRender = this;
            synchronized (actErrorPageRender) {
                if (null == this.i18n) {
                    this.i18n = Act.appConfig().i18nEnabled();
                }
            }
        }
        return this.i18n;
    }
}

