/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.Act;
import act.Zen;
import act.conf.AppConfigKey;
import act.conf.ConfLoader;
import act.internal.util.AppDescriptor;
import act.sys.Env;
import ascii.Image2ascii;
import com.github.lalyos.jfiglet.FigletFont;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.fusesource.jansi.Ansi;
import org.osgl.$;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.S;

public class Banner {
    private static String cachedBanner;
    private static final String[] _BANNER_FONTS;

    public static void print(AppDescriptor appDescriptor) {
        String banner = Banner.banner(appDescriptor);
        System.out.println(banner);
        cachedBanner = banner;
    }

    public static String cachedBanner() {
        return cachedBanner;
    }

    public static String banner(AppDescriptor appDescriptor) {
        String bannerText = null;
        String udfBanner = Banner.udfBanner();
        if (null != udfBanner) {
            bannerText = S.concat((String)udfBanner, (String)"\n");
        }
        if (null == bannerText) {
            bannerText = Banner.asciiArt(appDescriptor.getAppName());
        }
        int bannerTextWidth = Banner.width(bannerText);
        String favicon = Banner.favicon();
        int faviconWidth = Banner.width(favicon);
        int maxWidth = Math.max(faviconWidth, bannerTextWidth);
        S.Buffer sb = S.buffer();
        String actVersion = Act.VERSION.getVersion();
        if ("ACTFRAMEWORK".equals(appDescriptor.getAppName())) {
            sb.append(bannerText);
            if (S.notBlank((String)favicon)) {
                sb.append("\n");
                Banner.addFavicon(sb, favicon, maxWidth, faviconWidth);
            }
            int n = actVersion.length();
            int padLeft = (maxWidth - n + 1) / 2;
            sb.append(S.times((String)" ", (int)padLeft)).append(actVersion).append("\n");
        } else {
            sb.append(bannerText);
            if (S.notBlank((String)favicon)) {
                sb.append("\n");
                Banner.addFavicon(sb, favicon, maxWidth, faviconWidth);
                sb.append("\n");
                sb.append(Banner.poweredBy(maxWidth, actVersion, true));
            } else {
                sb.append(Banner.poweredBy(maxWidth, actVersion, false));
            }
            sb.append("\n\n version: ").append(appDescriptor.getVersion().getVersion());
        }
        File aFile = new File("");
        String group = Act.nodeGroup();
        sb.append("\nscan pkg: ").append(System.getProperty(AppConfigKey.SCAN_PACKAGE.key()));
        sb.append("\nbase dir: ").append(aFile.getAbsolutePath());
        sb.append("\n     pid: ").append(Env.PID.get());
        sb.append("\n profile: ").append(ConfLoader.confSetName());
        sb.append("\n    mode: ").append((Object)Act.mode());
        if (S.notBlank((String)group)) {
            sb.append("\n   group: ").append(group);
        }
        sb.append("\n");
        sb.append("\n     zen: ").append(Zen.wordsOfTheDay());
        sb.append("\n");
        return sb.toString();
    }

    private static void addFavicon(S.Buffer buffer, String favicon, int maxWidth, int faviconWidth) {
        if (S.blank((String)favicon)) {
            return;
        }
        int delta = maxWidth - faviconWidth;
        if (0 == delta) {
            buffer.append(favicon).append("\n");
        } else {
            String[] lines;
            int padLeft = (delta + 1) / 2;
            for (String line : lines = favicon.split("\n")) {
                buffer.append(S.times((String)" ", (int)padLeft)).append(line).append("\n");
            }
        }
    }

    private static String favicon() {
        boolean isIcon = true;
        URL url = Banner.class.getResource("/asset/favicon.png");
        if (null == url && null == (url = Banner.class.getResource("/asset/img/favicon.png"))) {
            url = Banner.class.getResource("/asset/image/favicon.png");
        }
        if (null != url) {
            isIcon = false;
        } else {
            url = Banner.class.getResource("/asset/favicon.ico");
            if (null == url && null == (url = Banner.class.getResource("/asset/img/favicon.ico"))) {
                url = Banner.class.getResource("/asset/image/favicon.ico");
            }
        }
        if (null == url) {
            return "";
        }
        return Banner.removeEndingBlankLines(Image2ascii.render(url, true, isIcon));
    }

    private static String asciiArt(String s) {
        String font = System.getProperty("banner.font");
        if (null == font) {
            int len = s.length();
            font = len < 5 ? "big" : (len < 7 ? "standard" : (len < 10 ? "small" : "mini"));
        } else if ("BianLian".equals(font)) {
            font = (String)$.random((Object[])_BANNER_FONTS);
        }
        String path = font.endsWith(".flf") ? font : S.concat((String)"/", (String)font, (String)".flf");
        File file = new File(path);
        if (file.exists() && file.canRead()) {
            try {
                return FigletFont.convertOneLine((File)file, (String)s.toUpperCase());
            }
            catch (IOException e) {
                throw E.ioException((IOException)e);
            }
        }
        InputStream is = Banner.class.getResourceAsStream(path);
        if (null == is) {
            is = Banner.class.getResourceAsStream("/standard.flf");
        }
        try {
            return FigletFont.convertOneLine((InputStream)is, (String)s.toUpperCase());
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
    }

    private static String removeEndingBlankLines(String text) {
        int lastLineBreak = text.lastIndexOf("\n");
        boolean lastLineIsBlank = S.isBlank((String)text.substring(lastLineBreak, text.length()));
        return lastLineIsBlank ? Banner.removeEndingBlankLines(text.substring(0, lastLineBreak)) : text;
    }

    private static int width(String banner) {
        String[] lines = banner.split("\n");
        int max = 0;
        for (String s : lines) {
            max = Math.max(max, s.length());
        }
        return max;
    }

    private static String udfBanner() {
        URL url = Banner.class.getResource("/act_banner.txt");
        return null == url ? null : IO.readContentAsString((URL)url);
    }

    private static String poweredBy(int width, String actVersion, boolean center) {
        int pw;
        String poweredBy = "powered by ActFramework ";
        if (Banner.supportAnsi()) {
            String raw = S.concat((String)"powered by @|bold ActFramework|@ ", (String)actVersion);
            poweredBy = Ansi.ansi().render(raw).toString();
            pw = raw.length() - 9;
        } else {
            poweredBy = poweredBy + actVersion;
            pw = poweredBy.length();
        }
        int gap = width - pw;
        gap = Math.max(gap, 0);
        if (gap == 0) {
            return poweredBy;
        }
        if (center) {
            gap = (gap + 1) / 2;
        }
        return S.concat((String)S.times((String)" ", (int)gap), (String)poweredBy);
    }

    private static boolean supportAnsi() {
        return !new File(".project").exists();
    }

    static {
        _BANNER_FONTS = new String[]{"banner3", "big", "doom", "marquee", "lcd", "mini", "slant", "small", "speed", "standard", "starwars"};
    }
}

