/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.app.AppByteCodeScannerBase;
import act.asm.AnnotationVisitor;
import act.asm.MethodVisitor;
import act.asm.Type;
import act.util.AsmTypes;
import act.util.ByteCodeVisitor;
import act.util.ClassFinderData;

public class ClassFinderByteCodeScanner
extends AppByteCodeScannerBase {
    @Override
    protected boolean shouldScan(String className) {
        return true;
    }

    @Override
    public ByteCodeVisitor byteCodeVisitor() {
        return new _ByteCodeVisitor();
    }

    @Override
    public void scanFinished(String className) {
    }

    private class _ByteCodeVisitor
    extends ByteCodeVisitor {
        private String className;

        private _ByteCodeVisitor() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            if (!AsmTypes.isPublic(access)) {
                return;
            }
            this.className = Type.getObjectType((String)name).getClassName();
        }

        public MethodVisitor visitMethod(int access, String name, String desc, final String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (null == this.className || !AsmTypes.isPublicNotAbstract(access)) {
                return mv;
            }
            final String methodName = name;
            final boolean isStatic = AsmTypes.isStatic(access);
            return new MethodVisitor(327680, mv){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    Type annoType = Type.getType((String)desc);
                    ClassFinderData.By by = null;
                    if (AsmTypes.SUB_CLASS_FINDER.asmType().equals((Object)annoType)) {
                        by = ClassFinderData.By.SUPER_TYPE;
                    } else if (AsmTypes.ANN_CLASS_FINDER.asmType().equals((Object)annoType)) {
                        by = ClassFinderData.By.ANNOTATION;
                    }
                    AnnotationVisitor av = super.visitAnnotation(desc, visible);
                    if (null == by) {
                        return av;
                    }
                    final ClassFinderData.By how = by;
                    return new AnnotationVisitor(327680, av){
                        ClassFinderData finder;
                        {
                            super(x0, x1);
                            this.finder = new ClassFinderData();
                        }

                        public void visit(String name, Object value) {
                            if ("value".equals(name)) {
                                Type type = (Type)value;
                                String className = type.getClassName();
                                this.finder.what(className);
                            } else if ("publicOnly".equals(name)) {
                                this.finder.publicOnly((Boolean)value);
                            } else if ("noAbstract".equals(name)) {
                                this.finder.noAbstract((Boolean)value);
                            }
                            super.visit(name, value);
                        }

                        public void visitEnum(String name, String desc, String value) {
                            this.finder.when(value);
                            super.visitEnum(name, desc, value);
                        }

                        public void visitEnd() {
                            if (ClassFinderData.By.SUPER_TYPE == how && !this.finder.whatSpecified()) {
                                this.finder.what(this.classNameFromMethodSignature());
                            }
                            this.finder.how(how);
                            this.finder.callback(_ByteCodeVisitor.this.className, methodName, isStatic);
                            if (this.finder.isValid()) {
                                this.finder.scheduleFind();
                            }
                            super.visitEnd();
                        }

                        private String classNameFromMethodSignature() {
                            String descriptor = signature.substring(18);
                            if ((descriptor = descriptor.substring(0, descriptor.length() - 4)).startsWith("+")) {
                                descriptor = descriptor.substring(1);
                            }
                            return Type.getType((String)descriptor).getClassName();
                        }
                    };
                }
            };
        }
    }
}

