/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.app.App;
import act.app.event.SysEventId;
import act.sys.Env;
import act.util.ClassInfoRepository;
import act.util.ClassNode;
import act.util.SubClassFinder;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.S;

public class ClassFinderData {
    private static final Logger logger = LogManager.get(ClassFinderData.class);
    private String what;
    private SysEventId when = SysEventId.DEPENDENCY_INJECTOR_PROVISIONED;
    private By how;
    private boolean publicOnly = true;
    private boolean noAbstract = true;
    private String className;
    private String methodName;
    private boolean isStatic;

    public String toString() {
        return this.how.toString(this);
    }

    public ClassFinderData what(String targetClassName) {
        this.what = targetClassName;
        return this;
    }

    public ClassFinderData publicOnly(boolean b) {
        this.publicOnly = b;
        return this;
    }

    public ClassFinderData noAbstract(boolean b) {
        this.noAbstract = b;
        return this;
    }

    public boolean whatSpecified() {
        return S.notBlank((String)this.what) && S.neq((String)SubClassFinder.DEF_VALUE, (String)this.what);
    }

    public ClassFinderData when(String loadOn) {
        this.when = SysEventId.valueOf(loadOn);
        return this;
    }

    public ClassFinderData how(By by) {
        this.how = by;
        return this;
    }

    public ClassFinderData callback(String className, String methodName, boolean isStatic) {
        this.className = className;
        this.methodName = methodName;
        this.isStatic = isStatic;
        return this;
    }

    public boolean isValid() {
        return S.noBlank((String[])new String[]{this.className, this.methodName});
    }

    public void scheduleFind() {
        if (logger.isTraceEnabled()) {
            logger.trace("schedule class finding for %s", new Object[]{this});
        }
        final App app = App.instance();
        app.jobManager().on(this.when, this.jobId(), new Runnable(){

            @Override
            public void run() {
                ClassFinderData.this.how.find(app, ClassFinderData.this);
            }
        });
    }

    private String jobId() {
        return S.fmt((String)"ClassFinder[%s@%s.%s]", (Object[])new Object[]{this.what, this.className, this.methodName});
    }

    public static enum By {
        ANNOTATION{

            @Override
            void tryFind(ClassNode startNode, boolean publicOnly, boolean noAbstract, Lang.Visitor<ClassNode> visitor) {
                startNode.visitAnnotatedClasses(visitor, publicOnly, noAbstract);
            }

            @Override
            String toString(ClassFinderData finder) {
                return "finding annotated by " + finder.what + " on " + (Object)((Object)finder.when) + " for " + finder.className + "::" + finder.methodName;
            }
        }
        ,
        SUPER_TYPE{

            @Override
            void tryFind(ClassNode startNode, boolean publicOnly, boolean noAbstract, Lang.Visitor<ClassNode> visitor) {
                startNode.visitSubTree(visitor, publicOnly, noAbstract);
            }

            @Override
            String toString(ClassFinderData finder) {
                return "finding sub type of " + finder.what + " on " + (Object)((Object)finder.when) + " for " + finder.className + "::" + finder.methodName;
            }
        };


        public void find(final App app, final ClassFinderData data) {
            ClassInfoRepository repo = app.classLoader().classInfoRepository();
            ClassNode theNode = repo.node(data.what);
            if (null == theNode) {
                logger.error("Cannot locate the \"what\" class[%s] in class info repository", new Object[]{data.what});
                return;
            }
            Lang.Visitor<ClassNode> visitor = new Lang.Visitor<ClassNode>(){

                public void visit(ClassNode classNode) throws Lang.Break {
                    Class targetClass;
                    ClassLoader cl = app.classLoader();
                    if (data.className.startsWith("act.")) {
                        cl = cl.getParent();
                    }
                    if (!Env.matches(targetClass = $.classForName((String)classNode.name(), (ClassLoader)app.classLoader()))) {
                        logger.debug("ignore target class[%s]: environment spec not matching", new Object[]{targetClass});
                        return;
                    }
                    if (data.isStatic) {
                        Class host = $.classForName((String)data.className, (ClassLoader)cl);
                        $.invokeStatic((Class)host, (String)data.methodName, (Object[])new Object[]{targetClass});
                    } else {
                        Object host = app.getInstance(data.className);
                        $.invokeVirtual(host, (String)data.methodName, (Object[])new Object[]{targetClass});
                    }
                }
            };
            this.tryFind(theNode, data.publicOnly, data.noAbstract, visitor);
        }

        abstract void tryFind(ClassNode var1, boolean var2, boolean var3, Lang.Visitor<ClassNode> var4);

        abstract String toString(ClassFinderData var1);
    }
}

