/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.util.ClassInfoRepository;
import act.util.ClassNodeDTO;
import act.util.DestroyableBase;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.E;

public class ClassNode
extends DestroyableBase {
    private transient ClassInfoRepository infoBase;
    private String name;
    private String canonicalName;
    private int modifiers;
    private ClassNode parent;
    private Set<ClassNode> children = new HashSet<ClassNode>();
    private Set<ClassNode> descendants = new HashSet<ClassNode>();
    Map<String, ClassNode> interfaces = new HashMap<String, ClassNode>();
    Set<ClassNode> annotations = new HashSet<ClassNode>();
    Set<ClassNode> annotated = new HashSet<ClassNode>();

    ClassNode(String name, int modifiers, ClassInfoRepository infoBase) {
        this(name, name.replace('$', '.'), modifiers, infoBase);
    }

    ClassNode(String name, String canonicalName, int modifiers, ClassInfoRepository infoBase) {
        this(name, canonicalName, infoBase);
        this.modifiers = modifiers;
    }

    ClassNode(String name, ClassInfoRepository infoBase) {
        this(name, name.replace('$', '.'), infoBase);
    }

    ClassNode(String name, String canonicalName, ClassInfoRepository infoBase) {
        E.NPE((Object)name, (Object)infoBase);
        this.name = name;
        this.canonicalName = canonicalName;
        this.infoBase = infoBase;
    }

    public String name() {
        return this.name;
    }

    public String canonicalName() {
        return this.canonicalName;
    }

    public ClassNode modifiers(int modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers) || Modifier.isInterface(this.modifiers);
    }

    public boolean publicNotAbstract() {
        return this.isPublic() && !this.isAbstract();
    }

    public ClassNode parent() {
        return this.parent;
    }

    public ClassNode parent(String name) {
        this.parent = this.infoBase.node(name);
        this.parent.addChild(this);
        for (ClassNode intf : this.parent.interfaces.values()) {
            this.addInterface(intf);
        }
        return this;
    }

    public ClassNode addInterface(String name) {
        ClassNode intf = this.infoBase.node(name);
        this.addInterface(intf);
        return this;
    }

    void addInterface(ClassNode classNode) {
        this.interfaces.put(classNode.name(), classNode);
        classNode.addChild(this);
        for (ClassNode child : this.children) {
            child.addInterface(classNode);
        }
    }

    public boolean hasInterface(String name) {
        return this.interfaces.containsKey(name);
    }

    public ClassNode annotatedWith(String name) {
        ClassNode anno = this.infoBase.node(name);
        this.annotations.add(anno);
        anno.annotated.add(this);
        return this;
    }

    void addAnnotation(ClassNode classNode) {
        this.annotations.add(classNode);
    }

    void addAnnontated(ClassNode classNode) {
        this.annotated.add(classNode);
    }

    public ClassNode visitTree(Lang.Function<ClassNode, ?> visitor) {
        this.visitTree(visitor, new HashSet<ClassNode>());
        return this;
    }

    private void visitTree(Lang.Function<ClassNode, ?> visitor, Set<ClassNode> visited) {
        this.visitSubTree(visitor, visited);
        if (!visited.contains(this)) {
            visitor.apply((Object)this);
        }
    }

    private void visitSubTree(Lang.Function<ClassNode, ?> visitor, Set<ClassNode> visited) {
        for (ClassNode child : this.children) {
            if (visited.contains(child)) continue;
            child.visitTree(visitor, visited);
            visited.add(child);
        }
    }

    private static Lang.Predicate<ClassNode> classNodeFilter(final boolean publicOnly, final boolean noAbstract) {
        return new Lang.Predicate<ClassNode>(){

            public boolean test(ClassNode classNode) {
                if (publicOnly && !classNode.isPublic()) {
                    return false;
                }
                return !noAbstract || !classNode.isAbstract();
            }
        };
    }

    public ClassNode visitTree(Lang.Visitor<ClassNode> visitor, boolean publicOnly, boolean noAbstract) {
        return this.visitTree((Lang.Function<ClassNode, ?>)$.guardedVisitor(ClassNode.classNodeFilter(publicOnly, noAbstract), visitor));
    }

    public ClassNode visitSubTree(Lang.Visitor<ClassNode> visitor) {
        this.visitSubTree((Lang.Function<ClassNode, ?>)visitor, (Set<ClassNode>)new HashSet<ClassNode>());
        return this;
    }

    public ClassNode visitSubTree(Lang.Visitor<ClassNode> visitor, boolean publicOnly, boolean noAbstract) {
        return this.visitSubTree((Lang.Visitor<ClassNode>)$.guardedVisitor(ClassNode.classNodeFilter(publicOnly, noAbstract), visitor));
    }

    public ClassNode visitPublicTreeNodes(Lang.Visitor<ClassNode> visitor) {
        return this.visitTree((Lang.Function<ClassNode, ?>)$.guardedVisitor((Lang.Function)new Lang.Predicate<ClassNode>(){

            public boolean test(ClassNode classNode) {
                return classNode.isPublic();
            }
        }, visitor));
    }

    public ClassNode visitPublicSubTreeNodes(Lang.Visitor<ClassNode> visitor) {
        return this.visitSubTree((Lang.Visitor<ClassNode>)$.guardedVisitor((Lang.Function)new Lang.Predicate<ClassNode>(){

            public boolean test(ClassNode classNode) {
                return classNode.isPublic();
            }
        }, visitor));
    }

    public ClassNode visitPublicNotAbstractSubTreeNodes(Lang.Visitor<ClassNode> visitor) {
        return this.visitSubTree((Lang.Visitor<ClassNode>)$.guardedVisitor((Lang.Function)new Lang.Predicate<ClassNode>(){

            public boolean test(ClassNode classNode) {
                return classNode.publicNotAbstract();
            }
        }, visitor));
    }

    public ClassNode visitPublicNotAbstractTreeNodes(Lang.Visitor<ClassNode> visitor) {
        return this.visitTree((Lang.Function<ClassNode, ?>)$.guardedVisitor((Lang.Function)new Lang.Predicate<ClassNode>(){

            public boolean test(ClassNode classNode) {
                return classNode.publicNotAbstract();
            }
        }, visitor));
    }

    public Set<ClassNode> annotatedClasses() {
        return C.set(this.annotated);
    }

    public ClassNode visitAnnotatedClasses(Lang.Visitor<ClassNode> visitor) {
        for (ClassNode annotated : this.annotated) {
            visitor.apply((Object)annotated);
        }
        return this;
    }

    public ClassNode visitAnnotatedClasses(Lang.Visitor<ClassNode> visitor, boolean publicOnly, boolean noAbstract) {
        return this.visitAnnotatedClasses((Lang.Visitor<ClassNode>)$.guardedVisitor(ClassNode.classNodeFilter(publicOnly, noAbstract), visitor));
    }

    public ClassNode visitPublicAnnotatedClasses(Lang.Visitor<ClassNode> visitor) {
        return this.visitAnnotatedClasses((Lang.Visitor<ClassNode>)$.guardedVisitor((Lang.Function)new Lang.Predicate<ClassNode>(){

            public boolean test(ClassNode classNode) {
                return classNode.isPublic();
            }
        }, visitor));
    }

    public ClassNode visitPublicNotAbstractAnnotatedClasses(Lang.Visitor<ClassNode> visitor) {
        return this.visitAnnotatedClasses((Lang.Visitor<ClassNode>)$.guardedVisitor((Lang.Function)new Lang.Predicate<ClassNode>(){

            public boolean test(ClassNode classNode) {
                return classNode.publicNotAbstract();
            }
        }, visitor));
    }

    public Set<ClassNode> annotations() {
        return C.set(this.annotations);
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ClassNode) {
            ClassNode that = (ClassNode)obj;
            return $.eq((Object)that.name, (Object)this.name);
        }
        return false;
    }

    public boolean isMyDescendant(ClassNode node) {
        return this.descendants.contains(node);
    }

    public boolean isMyAncestor(ClassNode node) {
        return node.isMyDescendant(this);
    }

    @Override
    protected void releaseResources() {
        this.descendants.clear();
        this.children.clear();
        this.interfaces.clear();
        this.annotated.clear();
        this.annotations.clear();
        this.infoBase = null;
    }

    ClassNodeDTO toDTO() {
        return new ClassNodeDTO(this);
    }

    ClassNode addChild(ClassNode node) {
        this.children.add(node);
        for (ClassNode intf : this.interfaces.values()) {
            node.addInterface(intf);
        }
        this.addDescendant(node);
        return this;
    }

    private void addDescendant(ClassNode node) {
        this.descendants.addAll(node.descendants);
        this.descendants.add(node);
        if (null != this.parent) {
            this.parent.addDescendant(node);
        }
    }
}

