/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.util.ClassInfoRepository;
import act.util.ClassNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class ClassNodeDTO {
    String name;
    String canonicalName;
    int modifiers;
    String parent;
    Set<String> interfaces = new HashSet<String>();
    Set<String> annotations = new HashSet<String>();
    Set<String> annotated = new HashSet<String>();

    ClassNodeDTO() {
    }

    ClassNodeDTO(ClassNode node) {
        this.name = node.name();
        this.canonicalName = node.canonicalName();
        this.modifiers = node.modifiers();
        ClassNode parent = node.parent();
        this.parent = parent == null ? null : parent.canonicalName();
        ClassNodeDTO.convert(node.interfaces.values(), this.interfaces);
        ClassNodeDTO.convert(node.annotations, this.annotations);
        ClassNodeDTO.convert(node.annotated, this.annotated);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    public void setInterfaces(Set<String> interfaces) {
        this.interfaces = interfaces;
    }

    public Set<String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Set<String> annotations) {
        this.annotations = annotations;
    }

    public Set<String> getAnnotated() {
        return this.annotated;
    }

    public void setAnnotated(Set<String> annotated) {
        this.annotated = annotated;
    }

    public ClassNode toClassNode(ClassInfoRepository infoBase) {
        return new ClassNode(this.name, this.canonicalName, this.modifiers, infoBase);
    }

    private static void convert(Collection<ClassNode> from, Set<String> to) {
        for (ClassNode node : from) {
            to.add(node.canonicalName());
        }
    }
}

