/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.asm.AnnotationVisitor;
import act.asm.ClassVisitor;
import act.asm.FieldVisitor;
import act.asm.Label;
import act.asm.MethodVisitor;
import act.asm.Type;
import act.data.annotation.Data;
import act.util.AppByteCodeEnhancer;
import act.util.EqualField;
import act.util.EqualIgnore;
import act.util.ObjectMetaInfo;
import java.util.List;
import org.osgl.Lang;
import org.osgl.util.FastStr;
import org.osgl.util.S;

public class DataObjectEnhancer
extends AppByteCodeEnhancer<DataObjectEnhancer> {
    private ObjectMetaInfo metaInfo;
    private static final String EQ_IGNORE = Type.getType(EqualIgnore.class).getDescriptor();
    private static final String EQ_FORCE = Type.getType(EqualField.class).getDescriptor();

    public DataObjectEnhancer() {
        super((Lang.Predicate<String>)S.F.startsWith((String)"act.").negate().or(new Lang.Function[]{S.F.startsWith((String)"act.fsa")}));
    }

    protected DataObjectEnhancer(ClassVisitor cv) {
        super((Lang.Predicate<String>)Lang.F.yes(), cv);
    }

    @Override
    protected Class<DataObjectEnhancer> subClass() {
        return DataObjectEnhancer.class;
    }

    @Override
    protected void reset() {
        this.metaInfo = null;
        super.reset();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        Type type = Type.getObjectType((String)name);
        Type superType = null == superName ? null : Type.getObjectType((String)superName);
        this.metaInfo = new ObjectMetaInfo(type, superType);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        boolean isStatic;
        FieldVisitor fv = super.visitField(access, name, desc, signature, value);
        boolean bl = isStatic = (access & 8) != 0;
        if (isStatic) {
            return fv;
        }
        if (this.metaInfo.hasDataAnnotation()) {
            boolean isTransient = (access & 0x80) != 0;
            Type fieldType = Type.getType((String)desc);
            final ObjectMetaInfo.FieldMetaInfo fi = this.metaInfo.addField(name, fieldType, isTransient);
            return new FieldVisitor(327680, fv){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    if (EQ_IGNORE.equals(desc)) {
                        fi.setEqualIgnore();
                    } else if (EQ_FORCE.equals(desc)) {
                        fi.setEqualForce();
                    }
                    return super.visitAnnotation(desc, visible);
                }
            };
        }
        return fv;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        AnnotationVisitor def = super.visitAnnotation(desc, visible);
        if (Type.getType(Data.class).getDescriptor().equals(desc)) {
            this.metaInfo.autoObjectAnnotationFound();
            return new AnnotationVisitor(327680, def){

                public void visit(String name, Object value) {
                    String s;
                    if ("callSuper".equals(name) && Boolean.parseBoolean(s = String.valueOf(value))) {
                        DataObjectEnhancer.this.metaInfo.requireCallSuper();
                    }
                    super.visit(name, value);
                }
            };
        }
        return def;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.metaInfo.hasDataAnnotation()) {
            if (S.eq((String)"hashCode", (String)name) && S.eq((String)"()I", (String)desc)) {
                this.metaInfo.hashCodeMethodFound();
            } else if (S.eq((String)"equals", (String)name) && S.eq((String)"(Ljava/lang/Object;)Z", (String)desc)) {
                this.metaInfo.equalMethodFound();
            }
        }
        return mv;
    }

    public void visitEnd() {
        if (this.metaInfo.shouldGenerateEqualsMethod()) {
            this.generateEqualsMethod();
        }
        if (this.metaInfo.shouldGenerateHashCodeMethod()) {
            this.generateHashCodeMethod();
        }
        super.visitEnd();
    }

    private void generateEqualsMethod() {
        MethodVisitor mv = DataObjectEnhancer.equalsMethodBegin(this);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        Label lbl_continue_with_instanceof_check = new Label();
        mv.visitJumpInsn(166, lbl_continue_with_instanceof_check);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(lbl_continue_with_instanceof_check);
        mv.visitVarInsn(25, 1);
        Type host = this.metaInfo.type();
        String hostInternalName = host.getInternalName();
        mv.visitTypeInsn(193, hostInternalName);
        Label lbl_exit_with_false = new Label();
        mv.visitJumpInsn(153, lbl_exit_with_false);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, hostInternalName);
        mv.visitVarInsn(58, 2);
        if (this.metaInfo.shouldCallSuper()) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 2);
            mv.visitMethodInsn(183, this.metaInfo.superType().getInternalName(), "equals", "(Ljava/lang/Object;)Z", false);
            mv.visitJumpInsn(153, lbl_exit_with_false);
        }
        List<ObjectMetaInfo.FieldMetaInfo> fields = this.metaInfo.fields();
        for (ObjectMetaInfo.FieldMetaInfo fi : fields) {
            fi.addEqualInstructions(host, mv, lbl_exit_with_false);
        }
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(lbl_exit_with_false);
        mv.visitInsn(3);
        mv.visitInsn(172);
        DataObjectEnhancer.equalsMethodEnd(mv);
    }

    private int fieldCount(List<ObjectMetaInfo.FieldMetaInfo> fields) {
        int cnt = 0;
        for (ObjectMetaInfo.FieldMetaInfo field : fields) {
            if (!field.eligible()) continue;
            ++cnt;
        }
        return cnt;
    }

    private void generateHashCodeMethod() {
        MethodVisitor mv = DataObjectEnhancer.hashCodeMethodBegin(this);
        Type host = this.metaInfo.type();
        List<ObjectMetaInfo.FieldMetaInfo> fields = this.metaInfo.fields();
        int fieldCount = this.fieldCount(fields);
        if (fieldCount < 6) {
            int cnt = 0;
            for (ObjectMetaInfo.FieldMetaInfo fi : fields) {
                boolean added = fi.addHashCodeInstruction(host, mv);
                if (!added) continue;
                ++cnt;
            }
            if (this.metaInfo.shouldCallSuper()) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, this.metaInfo.superType().getInternalName(), "hashCode", "()I", false);
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                ++cnt;
            }
            DataObjectEnhancer.hashCodeMethodEnd(mv, cnt);
        } else {
            mv.visitTypeInsn(187, "java/util/ArrayList");
            mv.visitInsn(89);
            mv.visitIntInsn(16, fieldCount);
            mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "(I)V", false);
            mv.visitVarInsn(58, 1);
            for (ObjectMetaInfo.FieldMetaInfo fi : fields) {
                if (!fi.eligible()) continue;
                mv.visitVarInsn(25, 1);
                fi.addHashCodeInstruction(host, mv);
                mv.visitMethodInsn(185, "java/util/List", "add", "(Ljava/lang/Object;)Z", true);
                mv.visitInsn(87);
            }
            if (this.metaInfo.shouldCallSuper()) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(183, this.metaInfo.superType().getInternalName(), "hashCode", "()I", false);
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
            }
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "org/osgl/$", "hc", "(Ljava/lang/Object;)I", false);
            mv.visitInsn(172);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    static MethodVisitor equalsMethodBegin(ClassVisitor cw) {
        MethodVisitor mv = cw.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        mv.visitCode();
        return mv;
    }

    static void equalsMethodEnd(MethodVisitor mv) {
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    static MethodVisitor hashCodeMethodBegin(ClassVisitor cw) {
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        return mv;
    }

    static void hashCodeMethodEnd(MethodVisitor mv, int fieldCnt) {
        FastStr signature = fieldCnt < 6 ? FastStr.of((String)"Ljava/lang/Object;").times(fieldCnt) : FastStr.of((String)"Ljava/lang/Object;").times(5).append("[Ljava/lang/Object;");
        signature = signature.prepend("(").append(")I");
        mv.visitMethodInsn(184, "org/osgl/Osgl", "hc", signature.toString(), false);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }
}

