/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.Destroyable;
import act.handler.builtin.controller.RequestHandlerProxy;
import act.util.LogSupport;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;

public abstract class DestroyableBase
extends LogSupport
implements Destroyable {
    private volatile boolean destroyed;
    private List<Destroyable> subResources = new ArrayList<Destroyable>();
    private volatile Class<? extends Annotation> scope;

    public DestroyableBase() {
    }

    protected DestroyableBase(boolean noLogger) {
        super(noLogger);
    }

    @Override
    public final void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        this.destroyed = true;
        Destroyable.Util.destroyAll(this.subResources, this.scope());
        this.releaseResources();
    }

    @Override
    public final boolean isDestroyed() {
        return this.destroyed;
    }

    protected void reload() {
        RequestHandlerProxy.releaseGlobalResources();
        this.destroyed = false;
    }

    protected void releaseResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<? extends Annotation> scope() {
        if (null == this.scope) {
            DestroyableBase destroyableBase = this;
            synchronized (destroyableBase) {
                if (null == this.scope) {
                    Class<?> c = this.getClass();
                    this.scope = c.isAnnotationPresent(RequestScoped.class) ? RequestScoped.class : (c.isAnnotationPresent(SessionScoped.class) ? SessionScoped.class : (c.isAnnotationPresent(ApplicationScoped.class) ? ApplicationScoped.class : NormalScope.class));
                }
            }
        }
        return this.scope;
    }

    public synchronized void addSubResource(Destroyable object) {
        this.subResources.add(object);
    }
}

