/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.app.ProjectLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgl.Lang;
import org.osgl.util.C;
import org.osgl.util.ListBuilder;

public enum Files {


    public static File file(File parent, String path) {
        return ProjectLayout.Utils.file(parent, path);
    }

    public static List<File> filter(File baseDir, Lang.F1<String, Boolean> filter) {
        ListBuilder list = ListBuilder.create((int)500);
        Files.filter(baseDir, filter, C.F.addTo((Collection)list));
        return list.toList();
    }

    public static void filter(File baseDir, Lang.F1<String, Boolean> filter, Lang.F1<File, ?> visitor) {
        File[] files = baseDir.listFiles();
        if (null == files) {
            return;
        }
        for (File file : files) {
            if (Files.isValidDir(file)) {
                Files.filter(file, filter, visitor);
                continue;
            }
            if (null != filter && !((Boolean)filter.apply((Object)file.getName())).booleanValue()) continue;
            visitor.apply((Object)file);
        }
    }

    public static List<File> filter(List<File> baseDirs, Lang.F1<String, Boolean> filter) {
        ListBuilder list = ListBuilder.create((int)500);
        Files.filter(baseDirs, filter, C.F.addTo((Collection)list));
        return list.toList();
    }

    public static void filter(List<File> baseDirs, Lang.F1<String, Boolean> filter, Lang.F1<File, ?> visitor) {
        ArrayList files = new ArrayList();
        for (File baseDir : baseDirs) {
            files.addAll(C.listOf((Object[])baseDir.listFiles()));
        }
        for (File file : files) {
            if (Files.isValidDir(file)) {
                Files.filter(file, filter, visitor);
                continue;
            }
            visitor.apply((Object)file);
        }
    }

    private static boolean isValidDir(File file) {
        return file.isDirectory() && !Files.isHiddenDir(file);
    }

    private static boolean isHiddenDir(File file) {
        return file.getName().startsWith(".");
    }
}

