/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.app.App;
import act.cli.util.MappedFastJsonNameFilter;
import act.data.DataPropertyRepository;
import act.util.ActContext;
import act.util.FastJsonIterable;
import act.util.FastJsonIterableSerializer;
import act.util.FastJsonJodaDateCodec;
import act.util.FastJsonKeywordCodec;
import act.util.FastJsonKvCodec;
import act.util.FastJsonPropertyPreFilter;
import act.util.FastJsonSObjectCodec;
import act.util.FastJsonValueObjectSerializer;
import act.util.PropertySpec;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.Writer;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.mvc.MvcConfig;
import org.osgl.storage.ISObject;
import org.osgl.storage.impl.SObject;
import org.osgl.util.IO;
import org.osgl.util.KV;
import org.osgl.util.KVStore;
import org.osgl.util.Keyword;
import org.osgl.util.S;
import org.osgl.util.ValueObject;

public class JsonUtilConfig {
    public static void configure(App app) {
        SerializeConfig config = SerializeConfig.getGlobalInstance();
        config.put(FastJsonIterable.class, (ObjectSerializer)FastJsonIterableSerializer.instance);
        FastJsonJodaDateCodec jodaDateCodec = new FastJsonJodaDateCodec(app);
        app.registerSingleton(FastJsonJodaDateCodec.class, jodaDateCodec);
        FastJsonValueObjectSerializer valueObjectSerializer = new FastJsonValueObjectSerializer();
        app.registerSingleton(FastJsonValueObjectSerializer.class, valueObjectSerializer);
        FastJsonKeywordCodec keywordCodec = new FastJsonKeywordCodec();
        FastJsonSObjectCodec sObjectCodec = new FastJsonSObjectCodec();
        config.put(DateTime.class, (ObjectSerializer)jodaDateCodec);
        config.put(LocalDate.class, (ObjectSerializer)jodaDateCodec);
        config.put(LocalTime.class, (ObjectSerializer)jodaDateCodec);
        config.put(LocalDateTime.class, (ObjectSerializer)jodaDateCodec);
        config.put(ValueObject.class, (ObjectSerializer)valueObjectSerializer);
        config.put(Keyword.class, (ObjectSerializer)keywordCodec);
        config.put(KV.class, (ObjectSerializer)FastJsonKvCodec.INSTANCE);
        config.put(KVStore.class, (ObjectSerializer)FastJsonKvCodec.INSTANCE);
        ParserConfig parserConfig = ParserConfig.getGlobalInstance();
        parserConfig.putDeserializer(DateTime.class, (ObjectDeserializer)jodaDateCodec);
        parserConfig.putDeserializer(LocalDate.class, (ObjectDeserializer)jodaDateCodec);
        parserConfig.putDeserializer(LocalTime.class, (ObjectDeserializer)jodaDateCodec);
        parserConfig.putDeserializer(LocalDateTime.class, (ObjectDeserializer)jodaDateCodec);
        parserConfig.putDeserializer(Keyword.class, (ObjectDeserializer)keywordCodec);
        parserConfig.putDeserializer(KV.class, (ObjectDeserializer)FastJsonKvCodec.INSTANCE);
        parserConfig.putDeserializer(KVStore.class, (ObjectDeserializer)FastJsonKvCodec.INSTANCE);
        parserConfig.putDeserializer(ISObject.class, (ObjectDeserializer)sObjectCodec);
        parserConfig.putDeserializer(SObject.class, (ObjectDeserializer)sObjectCodec);
        MvcConfig.jsonSerializer((Lang.Func2)new Lang.Func2<Writer, Object, Void>(){

            public Void apply(Writer writer, Object v) throws NotAppliedException, Lang.Break {
                new JsonWriter(v, null, false, ActContext.Base.currentContext()).apply(writer);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeJson(Writer os, Object object, SerializeConfig config, SerializeFilter[] filters, String dateFormat, int defaultFeatures, SerializerFeature ... features) {
        try (SerializeWriter writer = new SerializeWriter(os, defaultFeatures, features);){
            JSONSerializer serializer = new JSONSerializer(writer, config);
            if (dateFormat != null && dateFormat.length() != 0) {
                serializer.setDateFormat(dateFormat);
                serializer.config(SerializerFeature.WriteDateUseDateFormat, true);
            }
            if (filters != null) {
                for (SerializeFilter filter : filters) {
                    serializer.addFilter(filter);
                }
            }
            serializer.write(object);
        }
    }

    public static class JsonWriter
    extends Lang.Visitor<Writer> {
        private final Object v;
        private SerializerFeature[] features;
        private SerializeFilter[] filters;
        private String dateFormatPattern;
        private boolean disableCircularReferenceDetect;
        private boolean hasPropFilter;

        public JsonWriter(Object v, PropertySpec.MetaInfo spec, boolean format, ActContext context) {
            if (null == v) {
                this.v = "{}";
            } else if (v instanceof String) {
                String s = S.string((Object)v).trim();
                int len = s.length();
                if (0 == len) {
                    this.v = "{}";
                } else {
                    char a = s.charAt(0);
                    char z = s.charAt(len - 1);
                    this.v = '{' == a && '}' == z || '[' == a && ']' == z ? s : "{\"result\":" + s + "}";
                }
            } else {
                this.v = v;
                this.dateFormatPattern = null == context ? null : context.dateFormatPattern();
                this.filters = this.initFilters(v, spec, context);
                this.features = this.initFeatures(format, context);
            }
        }

        public void disableCircularReferenceDetect() {
            this.disableCircularReferenceDetect = true;
        }

        private SerializeFilter[] initFilters(Object v, PropertySpec.MetaInfo spec, ActContext context) {
            SerializeFilter[] filters;
            LinkedHashSet<Object> filterSet = new LinkedHashSet<Object>();
            FastJsonPropertyPreFilter propertyFilter = this.initPropertyPreFilter(v, spec, context);
            if (null != propertyFilter) {
                this.hasPropFilter = true;
            }
            if (null != spec && null != context) {
                MappedFastJsonNameFilter nameFilter = new MappedFastJsonNameFilter(spec.labelMapping(context));
                filterSet.add(nameFilter);
            }
            if (null != context && null != (filters = context.fastjsonFilters())) {
                for (SerializeFilter f2 : filters) {
                    filterSet.add(f2);
                }
            }
            if (null != propertyFilter) {
                filterSet.add(propertyFilter);
            }
            return filterSet.toArray(new SerializeFilter[filterSet.size()]);
        }

        private SerializerFeature[] initFeatures(boolean format, ActContext context) {
            SerializerFeature[] features;
            HashSet<SerializerFeature> featureSet = new HashSet<SerializerFeature>();
            if (format) {
                featureSet.add(SerializerFeature.PrettyFormat);
            }
            if (null != context && null != (features = context.fastjsonFeatures())) {
                for (SerializerFeature f2 : features) {
                    featureSet.add(f2);
                }
            }
            if (this.disableCircularReferenceDetect) {
                featureSet.add(SerializerFeature.DisableCircularReferenceDetect);
            }
            featureSet.add(SerializerFeature.WriteDateUseDateFormat);
            return featureSet.toArray(new SerializerFeature[featureSet.size()]);
        }

        private FastJsonPropertyPreFilter initPropertyPreFilter(Object v, PropertySpec.MetaInfo spec, ActContext context) {
            if (null != context) {
                spec = PropertySpec.MetaInfo.withCurrent(spec, context);
            }
            if (null == spec) {
                return null;
            }
            FastJsonPropertyPreFilter propertyFilter = new FastJsonPropertyPreFilter(new String[0]);
            List<String> outputs = spec.outputFields(context);
            Set<String> excluded = spec.excludedFields(context);
            if (excluded.isEmpty()) {
                if (outputs.isEmpty()) {
                    propertyFilter = null;
                } else {
                    propertyFilter.addIncludes(outputs);
                    if (FastJsonPropertyPreFilter.hasPattern(outputs)) {
                        propertyFilter.setFullPaths(context.app().service(DataPropertyRepository.class).propertyListOf(v.getClass()));
                    }
                }
            } else {
                propertyFilter.addExcludes(excluded);
                if (FastJsonPropertyPreFilter.hasPattern(excluded)) {
                    propertyFilter.setFullPaths(context.app().service(DataPropertyRepository.class).propertyListOf(v.getClass()));
                }
            }
            return propertyFilter;
        }

        public void visit(Writer writer) throws Lang.Break {
            if (this.v instanceof CharSequence) {
                IO.write((CharSequence)((CharSequence)this.v), (Writer)writer);
                return;
            }
            JsonUtilConfig.writeJson(writer, this.v, SerializeConfig.globalInstance, this.filters, this.dateFormatPattern, JSON.DEFAULT_GENERATE_FEATURE, this.features);
        }

        public Lang.Func0<String> asContentProducer() {
            final JsonWriter me = this;
            return new Lang.Func0<String>(){

                public String apply() throws NotAppliedException, Lang.Break {
                    S.Buffer buf = S.buffer();
                    me.visit((Writer)$.convert((Object)buf).to(Writer.class));
                    return buf.toString();
                }
            };
        }
    }
}

