/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

class LocalIpAddressUtil {
    LocalIpAddressUtil() {
    }

    public static Set<InetAddress> resolveLocalAddresses() {
        HashSet<InetAddress> addrs = new HashSet<InetAddress>();
        Enumeration<NetworkInterface> ns = null;
        try {
            ns = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        while (ns != null && ns.hasMoreElements()) {
            NetworkInterface n = ns.nextElement();
            Enumeration<InetAddress> is = n.getInetAddresses();
            while (is.hasMoreElements()) {
                InetAddress i = is.nextElement();
                if (i.isLoopbackAddress() || i.isLinkLocalAddress() || i.isMulticastAddress() || LocalIpAddressUtil.isSpecialIp(i.getHostAddress())) continue;
                addrs.add(i);
            }
        }
        return addrs;
    }

    public static Set<String> resolveLocalIps() {
        Set<InetAddress> addrs = LocalIpAddressUtil.resolveLocalAddresses();
        HashSet<String> ret = new HashSet<String>();
        for (InetAddress addr : addrs) {
            ret.add(addr.getHostAddress());
        }
        return ret;
    }

    public static InetAddress resolveLocalAddress() {
        Set<InetAddress> addrs = LocalIpAddressUtil.resolveLocalAddresses();
        if (addrs != null && !addrs.isEmpty()) {
            return addrs.iterator().next();
        }
        return null;
    }

    public static String ip() {
        InetAddress addr = LocalIpAddressUtil.resolveLocalAddress();
        if (null == addr) {
            return "127.0.0.1";
        }
        return addr.getHostAddress();
    }

    private static boolean isSpecialIp(String ip) {
        if (ip.contains(":")) {
            return true;
        }
        if (ip.startsWith("127.")) {
            return true;
        }
        if (ip.startsWith("169.254.")) {
            return true;
        }
        return ip.equals("255.255.255.255");
    }
}

