/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.cli.Command;
import act.cli.Required;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.S;

public class LogAdmin {
    @Command(name="act.log.level.show", help="Show log level")
    public String showLogLevel(@Required(value="specify LOGGER name") String name) {
        Logger logger = LogManager.get((String)name);
        if (logger.isTraceEnabled()) {
            return "trace";
        }
        if (logger.isDebugEnabled()) {
            return "debug";
        }
        if (logger.isInfoEnabled()) {
            return "info";
        }
        if (logger.isWarnEnabled()) {
            return "warn";
        }
        if (logger.isErrorEnabled()) {
            return "error";
        }
        return "fatal";
    }

    @Command(name="act.log.level.update", help="Update LOGGER level. Valid levels are:\n\t5 - fatal\n\t4 - error\n\t3 - warn\n\t2 - info\n\t1 - debug\n\t0 - trace")
    public String setLogLevel(@Required(value="specify LOGGER name") String name, @Required(value="specify log level") int level) {
        Logger.Level lvl = this.convert(level);
        Logger logger = LogManager.get((String)name);
        logger.setLevel(lvl);
        return S.fmt((String)"LOGGER[%s] level set to %s", (Object[])new Object[]{name, lvl.toString()});
    }

    private Logger.Level convert(int level) {
        switch (level) {
            case 0: {
                return Logger.Level.TRACE;
            }
            case 1: {
                return Logger.Level.DEBUG;
            }
            case 2: {
                return Logger.Level.INFO;
            }
            case 3: {
                return Logger.Level.WARN;
            }
            case 4: {
                return Logger.Level.ERROR;
            }
        }
        return Logger.Level.FATAL;
    }
}

