/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.asm.Label;
import act.asm.MethodVisitor;
import act.asm.Opcodes;
import act.asm.Type;
import java.util.ArrayList;
import java.util.List;
import org.osgl.$;
import org.osgl.util.S;

class ObjectMetaInfo
implements Opcodes {
    private Type superType;
    private Type type;
    private boolean callSuper;
    private List<FieldMetaInfo> fields = new ArrayList<FieldMetaInfo>();
    private boolean hasEqualMethod = false;
    private boolean hasHashCodeMethod = false;
    private boolean hasToStringMethod = false;
    private boolean hasAutoObjectAnnotation = false;
    private static Type OBJECT_TYPE = Type.getType(Object.class);

    ObjectMetaInfo(Type type, Type superType) {
        this.type = (Type)$.NPE((Object)type);
        if (null != superType && !OBJECT_TYPE.equals((Object)superType)) {
            this.superType = superType;
        }
    }

    Type type() {
        return this.type;
    }

    Type superType() {
        return this.superType;
    }

    List<FieldMetaInfo> fields() {
        return this.fields;
    }

    FieldMetaInfo addField(String fieldName, Type fieldType, boolean isTransient) {
        FieldMetaInfo fi = new FieldMetaInfo(fieldName, fieldType, isTransient);
        this.fields.add(fi);
        return fi;
    }

    void requireCallSuper() {
        this.callSuper = true;
    }

    boolean shouldCallSuper() {
        return this.callSuper && null != this.superType;
    }

    void equalMethodFound() {
        this.hasEqualMethod = true;
    }

    void hashCodeMethodFound() {
        this.hasHashCodeMethod = true;
    }

    void toStringMethodFound() {
        this.hasToStringMethod = true;
    }

    void autoObjectAnnotationFound() {
        this.hasAutoObjectAnnotation = true;
    }

    boolean hasDataAnnotation() {
        return this.hasAutoObjectAnnotation;
    }

    boolean shouldGenerateEqualsMethod() {
        return this.hasAutoObjectAnnotation && !this.hasEqualMethod;
    }

    boolean shouldGenerateHashCodeMethod() {
        return this.hasAutoObjectAnnotation && !this.hasHashCodeMethod;
    }

    static class FieldMetaInfo
    implements Opcodes {
        private String name;
        private boolean isTransient = false;
        private boolean equalForce = false;
        private boolean equalIgnore = false;
        private Type type;

        FieldMetaInfo(String name, Type type, boolean isTransient) {
            this.name = (String)$.NPE((Object)name);
            this.type = (Type)$.NPE((Object)type);
            this.isTransient = isTransient;
        }

        void setEqualForce() {
            this.equalForce = true;
        }

        void setEqualIgnore() {
            this.equalIgnore = true;
        }

        void addEqualInstructions(Type host, MethodVisitor mv, Label jumpTo) {
            if (!this.eligible()) {
                return;
            }
            String typeDesc = this.type.getDescriptor();
            mv.visitVarInsn(25, 2);
            mv.visitFieldInsn(180, host.getInternalName(), this.name, typeDesc);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, host.getInternalName(), this.name, typeDesc);
            String s = typeDesc;
            if (s.length() > 1) {
                s = OBJECT_TYPE.getDescriptor();
            }
            String op = "eq";
            if (typeDesc.startsWith("[")) {
                op = "eq2";
            }
            mv.visitMethodInsn(184, "org/osgl/Osgl", op, S.fmt((String)"(%s%s)Z", (Object[])new Object[]{s, s}), false);
            mv.visitJumpInsn(153, jumpTo);
        }

        boolean addHashCodeInstruction(Type host, MethodVisitor mv) {
            if (!this.eligible()) {
                return false;
            }
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, host.getInternalName(), this.name, this.type.getDescriptor());
            this.convertFromPrimaryType(this.type, mv);
            return true;
        }

        private void convertFromPrimaryType(Type fieldType, MethodVisitor mv) {
            switch (fieldType.getSort()) {
                case 1: {
                    mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;", false);
                    break;
                }
                case 3: {
                    mv.visitMethodInsn(184, "java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;", false);
                    break;
                }
                case 2: {
                    mv.visitMethodInsn(184, "java/lang/Character", "valueOf", "(C)Ljava/lang/Character;", false);
                    break;
                }
                case 4: {
                    mv.visitMethodInsn(184, "java/lang/Short", "valueOf", "(S)Ljava/lang/Short;", false);
                    break;
                }
                case 5: {
                    mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
                    break;
                }
                case 7: {
                    mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;", false);
                    break;
                }
                case 6: {
                    mv.visitMethodInsn(184, "java/lang/Float", "valueOf", "(F)Ljava/lang/Float;", false);
                    break;
                }
                case 8: {
                    mv.visitMethodInsn(184, "java/lang/Double", "valueOf", "(D)Ljava/lang/Double;", false);
                    break;
                }
            }
        }

        boolean eligible() {
            return !this.equalIgnore && (!this.isTransient || this.equalForce);
        }
    }
}

