/*
 * Decompiled with CFR 0.152.
 */
package act.util;

import act.app.ActionContext;
import org.osgl.http.H;
import org.osgl.util.E;
import org.osgl.util.S;

public interface SessionMapper {
    public void serializeSession(H.Cookie var1, ActionContext var2);

    public void serializeFlash(H.Cookie var1, ActionContext var2);

    public String deserializeSession(ActionContext var1);

    public String deserializeFlash(ActionContext var1);

    public static class HeaderSessionMapper
    implements SessionMapper {
        public static final String DEF_HEADER_PREFIX = "X-Act-";
        private String headerPrefix;

        public HeaderSessionMapper(String headerPrefix) {
            E.illegalArgumentIf((boolean)S.blank((String)headerPrefix));
            this.headerPrefix = headerPrefix;
        }

        public HeaderSessionMapper() {
            this(DEF_HEADER_PREFIX);
        }

        @Override
        public void serializeSession(H.Cookie sessionCookie, ActionContext context) {
            context.resp().header(this.sessionHeaderName(), sessionCookie.value());
        }

        @Override
        public void serializeFlash(H.Cookie flashCookie, ActionContext context) {
            context.resp().header(this.flashHeaderName(), flashCookie.value());
        }

        @Override
        public String deserializeSession(ActionContext context) {
            return context.req().header(this.sessionHeaderName());
        }

        @Override
        public String deserializeFlash(ActionContext context) {
            return context.req().header(this.flashHeaderName());
        }

        private String sessionHeaderName() {
            return this.headerPrefix + "Session";
        }

        private String flashHeaderName() {
            return this.headerPrefix + "Flash";
        }
    }

    public static class DefaultSessionMapper
    implements SessionMapper {
        public static SessionMapper INSTANCE = new DefaultSessionMapper();

        @Override
        public void serializeSession(H.Cookie sessionCookie, ActionContext context) {
            context.resp().addCookie(sessionCookie);
        }

        @Override
        public void serializeFlash(H.Cookie flashCookie, ActionContext context) {
            context.resp().addCookie(flashCookie);
        }

        @Override
        public String deserializeSession(ActionContext context) {
            H.Cookie sessionCookie = context.req().cookie(context.config().sessionCookieName());
            return null == sessionCookie ? null : sessionCookie.value();
        }

        @Override
        public String deserializeFlash(ActionContext context) {
            H.Cookie flashCookie = context.req().cookie(context.config().flashCookieName());
            return null == flashCookie ? null : flashCookie.value();
        }

        public static SessionMapper wrap(final SessionMapper theMapper) {
            if (null == theMapper) {
                return INSTANCE;
            }
            if (DefaultSessionMapper.class.equals(theMapper.getClass())) {
                return theMapper;
            }
            return new SessionMapper(){

                @Override
                public void serializeSession(H.Cookie sessionCookie, ActionContext context) {
                    theMapper.serializeSession(sessionCookie, context);
                    INSTANCE.serializeSession(sessionCookie, context);
                }

                @Override
                public void serializeFlash(H.Cookie flashCookie, ActionContext context) {
                    theMapper.serializeFlash(flashCookie, context);
                    INSTANCE.serializeFlash(flashCookie, context);
                }

                @Override
                public String deserializeSession(ActionContext context) {
                    String s = theMapper.deserializeSession(context);
                    return S.blank((String)s) ? INSTANCE.deserializeSession(context) : s;
                }

                @Override
                public String deserializeFlash(ActionContext context) {
                    String s = theMapper.deserializeFlash(context);
                    return S.blank((String)s) ? INSTANCE.deserializeFlash(context) : s;
                }
            };
        }
    }
}

