/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.Act;
import act.app.ActionContext;
import act.app.App;
import act.app.AppByteCodeScannerBase;
import act.asm.AnnotationVisitor;
import act.asm.AsmException;
import act.asm.MethodVisitor;
import act.inject.genie.GenieInjector;
import act.inject.param.ParamValueLoader;
import act.inject.param.ProvidedValueLoader;
import act.mail.MailerContext;
import act.plugin.Plugin;
import act.util.AsmTypes;
import act.util.ByteCodeVisitor;
import act.view.ActionViewVarDef;
import act.view.MailerViewVarDef;
import act.view.ProvidesImplicitTemplateVariable;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.osgl.$;
import org.osgl.inject.BeanSpec;
import org.osgl.inject.Injector;
import org.osgl.util.E;
import org.osgl.util.S;

public abstract class ImplicitVariableProvider
implements Plugin {
    public abstract List<ActionViewVarDef> implicitActionViewVariables();

    public abstract List<MailerViewVarDef> implicitMailerViewVariables();

    @Override
    public void register() {
        Act.viewManager().register(this);
    }

    public static class TemplateVariableScanner
    extends AppByteCodeScannerBase {
        private Set<Meta> providers = new HashSet<Meta>();

        public TemplateVariableScanner(final App app) {
            app.jobManager().beforeAppStart(new Runnable(){

                @Override
                public void run() {
                    TemplateVariableScanner.this.register(app);
                }
            });
        }

        @Override
        protected boolean shouldScan(String className) {
            return true;
        }

        @Override
        public ByteCodeVisitor byteCodeVisitor() {
            return new ByteCodeVisitor(){
                private String className;

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    if (2.isPublic(access)) {
                        this.className = act.asm.Type.getObjectType((String)name).getClassName();
                    }
                    super.visit(version, access, name, signature, superName, interfaces);
                }

                public MethodVisitor visitMethod(int access, final String methodName, String desc, String signature, String[] exceptions) {
                    MethodVisitor mv = super.visitMethod(access, methodName, desc, signature, exceptions);
                    if (null == this.className) {
                        return mv;
                    }
                    final boolean isStatic = 2.isStatic(access);
                    return new MethodVisitor(327680, mv){

                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            AnnotationVisitor av = super.visitAnnotation(desc, visible);
                            act.asm.Type annoType = act.asm.Type.getType((String)desc);
                            if (AsmTypes.TEMPLATE_VARIABLE.asmType().equals((Object)annoType)) {
                                final Meta meta = new Meta();
                                meta.className = className;
                                meta.methodName = methodName;
                                meta.isStatic = isStatic;
                                if (TemplateVariableScanner.this.providers.contains(meta)) {
                                    throw AsmException.of((String)"@ProvidesImplicitTemplateVariable annotated method cannot be overloaded: %s", (Object[])new Object[]{meta.toString()});
                                }
                                TemplateVariableScanner.this.providers.add(meta);
                                return new AnnotationVisitor(327680, av){

                                    public void visit(String name, Object value) {
                                        if ("value".equals(name)) {
                                            meta.varName = value.toString();
                                        }
                                        super.visit(name, value);
                                    }
                                };
                            }
                            return av;
                        }
                    };
                }
            };
        }

        @Override
        public void scanFinished(String className) {
        }

        private void register(App app) {
            for (Meta meta : this.providers) {
                this.register(meta, app);
            }
        }

        private void register(Meta meta, App app) {
            Class cls = $.classForName((String)meta.className, (ClassLoader)app.classLoader());
            Method method = this.findMethod(cls, meta.methodName);
            E.unexpectedIf((null == method ? 1 : 0) != 0, (String)"Unable to find method %s", (Object[])new Object[]{meta});
            this.register(meta, cls, method, app);
        }

        private Method findMethod(Class<?> cls, String methodName) {
            Method[] methods;
            for (Method method : methods = cls.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || !method.isAnnotationPresent(ProvidesImplicitTemplateVariable.class)) continue;
                return method;
            }
            return null;
        }

        private void register(Meta meta, Class<?> cls, Method method, App app) {
            final ReflectedActionViewVarDef def = new ReflectedActionViewVarDef(meta, cls, method, app);
            if (def.supportMailer) {
                MailerViewVarDef mailerVarDef = new MailerViewVarDef(meta.varName(), def.returnType(app)){

                    @Override
                    public Object eval(MailerContext context) {
                        return def.getValue(context.app());
                    }
                };
                Act.viewManager().registerAppDefinedVar(mailerVarDef);
            }
            if (def.supportAction) {
                ActionViewVarDef actionVarDef = new ActionViewVarDef(meta.varName(), def.returnType(app)){

                    @Override
                    public Object eval(ActionContext context) {
                        return def.getValue(context.app());
                    }
                };
                Act.viewManager().registerAppDefinedVar(actionVarDef);
            }
        }

        private static class ReflectedActionViewVarDef {
            private Class<?> cls;
            private Method method;
            private MethodAccess methodAccess;
            private int methodIndex;
            private ParamValueLoader[] loaders;
            private boolean supportAction;
            private boolean supportMailer;
            private int paramLen;

            protected ReflectedActionViewVarDef(Meta meta, Class<?> cls, Method method, App app) {
                this.cls = cls;
                this.method = method;
                if (!meta.isStatic) {
                    this.methodAccess = MethodAccess.get(cls);
                    this.methodIndex = this.methodAccess.getIndex(method.getName(), (Class[])method.getParameterTypes());
                }
                this.initLoaders(app);
            }

            private void initLoaders(App app) {
                Type[] types = this.method.getGenericParameterTypes();
                int len = types.length;
                ParamValueLoader[] loaders = new ParamValueLoader[len];
                if (0 < len) {
                    GenieInjector injector = (GenieInjector)app.injector();
                    Annotation[][] annos = this.method.getParameterAnnotations();
                    for (int i = 0; i < len; ++i) {
                        Type type = types[i];
                        Annotation[] aa = annos[i];
                        BeanSpec spec = BeanSpec.of((Type)type, (Annotation[])aa, (Injector)injector);
                        E.unexpectedIf((!injector.isProvided(spec) ? 1 : 0) != 0, (String)"", (Object[])new Object[0]);
                        loaders[i] = ProvidedValueLoader.get(spec, injector);
                        if (spec.isInstanceOf(ActionContext.class) || this.requireAction(type)) {
                            this.supportAction = true;
                            continue;
                        }
                        if (!spec.isInstanceOf(MailerContext.class)) continue;
                        this.supportMailer = true;
                    }
                }
                if (!this.supportAction && !this.supportMailer) {
                    this.supportAction = true;
                    this.supportMailer = true;
                }
                this.loaders = loaders;
                this.paramLen = len;
            }

            private boolean requireAction(Type type) {
                String name = type.toString();
                return name.contains("org.osgl.http");
            }

            BeanSpec returnType(App app) {
                return BeanSpec.of((Type)this.method.getGenericReturnType(), null, app.injector());
            }

            Object getValue(App app) {
                Object[] params = this.params();
                if (null != this.methodAccess) {
                    return this.methodAccess.invoke(app.getInstance(this.cls), this.methodIndex, params);
                }
                return $.invokeStatic((Method)this.method, (Object[])params);
            }

            private Object[] params() {
                Object[] params = new Object[this.paramLen];
                for (int i = 0; i < this.paramLen; ++i) {
                    ParamValueLoader loader = this.loaders[i];
                    params[i] = loader.load(null, null, false);
                }
                return params;
            }
        }

        private static class Meta {
            String className;
            String methodName;
            String varName;
            boolean isStatic;

            private Meta() {
            }

            public int hashCode() {
                return $.hc((Object)this.className, (Object)this.methodName);
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj instanceof Meta) {
                    Meta that = (Meta)$.cast((Object)obj);
                    return $.eq((Object)that.className, (Object)this.className) && $.eq((Object)that.methodName, (Object)this.methodName);
                }
                return false;
            }

            String varName() {
                return null == this.varName || S.eq((String)"NULL", (String)this.varName) ? this.methodName : this.varName;
            }

            public String toString() {
                return S.concat((String)"Template variable provider: ", (String)this.className, (String)"::", (String)this.methodName);
            }
        }
    }
}

