/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.Act;
import act.ActResponse;
import act.app.ActionContext;
import act.mail.MailerContext;
import act.view.ActionViewVarDef;
import act.view.MailerViewVarDef;
import act.view.Template;
import java.nio.charset.Charset;
import java.util.Map;
import org.osgl.http.H;
import org.osgl.util.Charsets;

public abstract class TemplateBase
implements Template {
    private static final Charset UTF8 = Charsets.UTF_8;

    @Override
    public void merge(ActionContext context) {
        Map<String, Object> renderArgs = context.renderArgs();
        if (!context.isByPassImplicitTemplateVariable()) {
            this.exposeImplicitVariables(renderArgs, context);
        }
        this.beforeRender(context);
        ActResponse<?> resp = context.resp();
        this.merge(renderArgs, resp);
        resp.commit();
    }

    @Override
    public String render(ActionContext context) {
        Map<String, Object> renderArgs = context.renderArgs();
        this.exposeImplicitVariables(renderArgs, context);
        this.beforeRender(context);
        return this.render(renderArgs);
    }

    @Override
    public String render(MailerContext context) {
        Map<String, Object> renderArgs = context.renderArgs();
        this.exposeImplicitVariables(renderArgs, context);
        this.beforeRender(context);
        return this.render(renderArgs);
    }

    protected void beforeRender(ActionContext context) {
    }

    protected void beforeRender(MailerContext context) {
    }

    protected void merge(Map<String, Object> renderArgs, H.Response response) {
        String result = this.render(renderArgs);
        response.writeContent(result);
    }

    protected abstract String render(Map<String, Object> var1);

    private void exposeImplicitVariables(Map<String, Object> renderArgs, ActionContext context) {
        for (ActionViewVarDef var : Act.viewManager().implicitActionViewVariables()) {
            Object val = var.eval(context);
            if (null == val) continue;
            renderArgs.put(var.name(), val);
        }
    }

    private void exposeImplicitVariables(Map<String, Object> renderArgs, MailerContext context) {
        for (MailerViewVarDef var : Act.viewManager().implicitMailerViewVariables()) {
            Object val = var.eval(context);
            if (null == val) continue;
            renderArgs.put(var.name(), val);
        }
    }
}

