/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.app.App;
import act.app.DevModeClassLoader;
import act.app.Source;
import act.app.SourceInfo;
import act.app.SourceInfoImpl;
import act.view.ActErrorResult;
import java.util.List;
import org.osgl.util.S;

public abstract class TemplateException
extends ActErrorResult {
    protected SourceInfo templateInfo;
    private String errorSpotTraceLine = null;

    public TemplateException(Exception t) {
        super(t);
    }

    public final SourceInfo templateSourceInfo() {
        return this.templateInfo;
    }

    public abstract String errorMessage();

    @Override
    public boolean isErrorSpot(String traceLine, String nextTraceLine) {
        if (null == this.errorSpotTraceLine) {
            this.errorSpotTraceLine = this.findErrorSpotTraceLine(this.stackTrace());
        }
        return S.eq((String)traceLine, (String)this.errorSpotTraceLine);
    }

    @Override
    public synchronized Throwable getCause() {
        Throwable t0 = super.getCause();
        if (null == t0) {
            return null;
        }
        Throwable t = t0.getCause();
        return null == t ? t0 : t;
    }

    public Throwable getDirectCause() {
        return super.getCause();
    }

    protected String findErrorSpotTraceLine(List<String> stackTrace) {
        String spotLine = null;
        String lastLine = null;
        for (String line : stackTrace) {
            if (line.contains("sun.reflect.NativeMethodAccessorImpl.invoke0")) {
                spotLine = lastLine;
            }
            if (this.isTemplateEngineInvokeLine(line)) {
                return spotLine;
            }
            lastLine = line;
        }
        return null;
    }

    protected static SourceInfo getJavaSourceInfo(Throwable cause) {
        if (null == cause) {
            return null;
        }
        cause = TemplateException.rootCauseOf(cause);
        DevModeClassLoader cl = (DevModeClassLoader)App.instance().classLoader();
        for (StackTraceElement stackTraceElement : cause.getStackTrace()) {
            Source source;
            int line = stackTraceElement.getLineNumber();
            if (line <= 0 || null == (source = cl.source(stackTraceElement.getClassName()))) continue;
            return new SourceInfoImpl(source, line);
        }
        return null;
    }

    protected abstract boolean isTemplateEngineInvokeLine(String var1);
}

