/*
 * Decompiled with CFR 0.152.
 */
package act.view;

import act.Act;
import act.Destroyable;
import act.app.App;
import act.conf.AppConfig;
import act.util.ActContext;
import act.util.DestroyableBase;
import act.view.ActionViewVarDef;
import act.view.ImplicitVariableProvider;
import act.view.MailerViewVarDef;
import act.view.Template;
import act.view.TemplatePathResolver;
import act.view.VarDef;
import act.view.View;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.osgl.Lang;
import org.osgl.exception.UnexpectedException;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;

public class ViewManager
extends DestroyableBase {
    private C.List<View> viewList = C.newList();
    private Map<String, ActionViewVarDef> implicitActionViewVariables = new HashMap<String, ActionViewVarDef>();
    private Map<String, MailerViewVarDef> implicitMailerViewVariables = new HashMap<String, MailerViewVarDef>();
    private Map<String, VarDef> appDefined = new HashMap<String, VarDef>();
    private Map<String, Template> templateCache = new HashMap<String, Template>();
    private boolean multiViews = false;

    void register(View view) {
        E.NPE((Object)view);
        if (this.registered(view)) {
            throw new UnexpectedException("View[%s] already registered", new Object[]{view.name()});
        }
        this.viewList.add((Object)view);
    }

    void register(ImplicitVariableProvider implicitVariableProvider) {
        E.NPE((Object)implicitVariableProvider);
        List<ActionViewVarDef> l0 = implicitVariableProvider.implicitActionViewVariables();
        for (ActionViewVarDef var : l0) {
            this._register(var, this.implicitActionViewVariables, false);
        }
        List<MailerViewVarDef> l1 = implicitVariableProvider.implicitMailerViewVariables();
        for (MailerViewVarDef var : l1) {
            this._register(var, this.implicitMailerViewVariables, false);
        }
    }

    void registerAppDefinedVar(ActionViewVarDef var) {
        this._register(var, this.implicitActionViewVariables, true);
    }

    void registerAppDefinedVar(MailerViewVarDef var) {
        this._register(var, this.implicitMailerViewVariables, true);
    }

    private <T extends VarDef> void _register(T var, Map<String, T> map, boolean fromApp) {
        if (map.containsKey(var.name())) {
            throw new UnexpectedException("Implicit variable[%s] has already been registered", new Object[]{var.name()});
        }
        map.put(var.name(), var);
        if (fromApp) {
            this.appDefined.put(var.name(), var);
        }
    }

    public void clearAppDefinedVars() {
        for (String name : this.appDefined.keySet()) {
            this.implicitActionViewVariables.remove(name);
            this.implicitMailerViewVariables.remove(name);
        }
        this.appDefined.clear();
    }

    public void onAppStart() {
        int viewCount = this.viewList.size();
        this.multiViews = viewCount > 1;
    }

    public void reload(App app) {
        for (View view : this.viewList) {
            view.reload(app);
        }
    }

    public View view(String name) {
        Lang.Option<View> viewBag = this.findViewByName(name);
        return viewBag.isDefined() ? (View)viewBag.get() : null;
    }

    public Template load(ActContext context) {
        Template template;
        Template cached = context.cachedTemplate();
        if (null != cached) {
            return cached;
        }
        AppConfig config = context.config();
        String templateContent = context.templateContent();
        if (S.notEmpty((String)templateContent)) {
            template = this.getInlineTemplate(context, config, templateContent);
        } else {
            String amendedPath;
            TemplatePathResolver resolver = config.templatePathResolver();
            String path = resolver.resolve(context);
            template = this.getTemplate(context, config, path);
            if (null == template && S.neq((String)(amendedPath = resolver.resolveWithContextMethodPath(context)), (String)path) && null != (template = this.getTemplate(context, config, amendedPath))) {
                context.templatePath(amendedPath);
            }
        }
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Template getTemplate(String path) {
        ActContext.Base<?> ctx = ActContext.Base.currentContext();
        if (null != ctx) {
            String curPath = ctx.templatePath();
            ctx.templateLiteral(path);
            try {
                Template template = this.load(ctx);
                return template;
            }
            finally {
                ctx.templatePath(curPath);
            }
        }
        String templatePath = S.ensureStartsWith((String)path, (char)'/');
        Template template = null;
        View defView = Act.appConfig().defaultView();
        if (null != defView) {
            Template template2 = template = !ViewManager.isTemplatePath(path) ? defView.loadInlineTemplate(path) : defView.loadTemplate(templatePath);
        }
        if (null == template && this.multiViews) {
            View view;
            Iterator iterator = this.viewList.iterator();
            while (iterator.hasNext() && ((view = (View)iterator.next()) == defView || null == (template = view.loadTemplate(templatePath)))) {
            }
        }
        if (null != template) {
            this.templateCache.put(path, template);
        }
        return template;
    }

    private Template getInlineTemplate(ActContext context, AppConfig config, String content) {
        View defView = config.defaultView();
        if (null != defView && defView.appliedTo(context)) {
            return defView.loadInlineTemplate(content);
        }
        return null;
    }

    private Template getTemplate(ActContext context, AppConfig config, String path) {
        Template template = this.cached(path);
        if (null != template) {
            return template;
        }
        String templatePath = S.ensureStartsWith((String)path, (char)'/');
        View defView = config.defaultView();
        if (null != defView && defView.appliedTo(context)) {
            template = defView.loadTemplate(templatePath);
        }
        if (null == template && this.multiViews) {
            View view;
            Iterator iterator = this.viewList.iterator();
            while (iterator.hasNext() && ((view = (View)iterator.next()) == defView || !view.appliedTo(context) || null == (template = view.loadTemplate(templatePath)))) {
            }
        }
        if (null != template) {
            context.cacheTemplate(template);
            this.cache(path, template);
        }
        return template;
    }

    public Collection<ActionViewVarDef> implicitActionViewVariables() {
        return this.implicitActionViewVariables.values();
    }

    public Collection<MailerViewVarDef> implicitMailerViewVariables() {
        return this.implicitMailerViewVariables.values();
    }

    public void reset() {
        this.viewList.clear();
        this.templateCache.clear();
    }

    @Override
    protected void releaseResources() {
        Destroyable.Util.tryDestroyAll(this.viewList, ApplicationScoped.class);
        this.viewList = null;
        this.implicitActionViewVariables.clear();
        this.implicitActionViewVariables = null;
        this.implicitMailerViewVariables.clear();
        this.implicitMailerViewVariables = null;
        this.templateCache.clear();
        this.templateCache = null;
    }

    private boolean registered(View view) {
        String name = view.name().toUpperCase();
        return this.findViewByName(name).isDefined();
    }

    private Lang.Option<View> findViewByName(final String name) {
        return this.viewList.findFirst((Lang.Function)new Lang.Predicate<View>(){

            public boolean test(View view) {
                return view.name().toUpperCase().equals(name.toUpperCase());
            }
        });
    }

    private Template cached(String key) {
        return Act.isDev() ? null : this.templateCache.get(key);
    }

    private void cache(String key, Template template) {
        if (Act.isProd()) {
            this.templateCache.put(key, template);
        }
    }

    public static boolean isTemplatePath(String string) {
        int sz = string.length();
        if (sz == 0) {
            return true;
        }
        for (int i = 0; i < sz; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': 
                case '\t': 
                case ' ': 
                case '!': 
                case '#': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case ',': 
                case ':': 
                case ';': 
                case '<': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    return false;
                }
            }
        }
        return true;
    }
}

