/*
 * Decompiled with CFR 0.152.
 */
package act.view.rythm;

import act.app.ActionContext;
import act.mail.MailerContext;
import act.view.TemplateBase;
import java.util.Locale;
import java.util.Map;
import org.osgl.$;
import org.rythmengine.RythmEngine;
import org.rythmengine.internal.compiler.TemplateClass;
import org.rythmengine.internal.compiler.TemplateClassManager;
import org.rythmengine.internal.dialect.BasicRythm;
import org.rythmengine.resource.ITemplateResource;
import org.rythmengine.template.ITemplate;

public class RythmTemplate
extends TemplateBase {
    private RythmEngine engine;
    private String literal;
    private boolean inline;

    public RythmTemplate(RythmEngine engine, String literal) {
        this(engine, literal, false);
    }

    public RythmTemplate(RythmEngine engine, String literal, boolean inline) {
        this.engine = (RythmEngine)$.notNull((Object)engine);
        this.literal = literal;
        this.inline = inline;
    }

    @Override
    protected void beforeRender(ActionContext context) {
        Locale locale = context.locale();
        this.engine = this.engine.prepare(locale);
    }

    @Override
    protected void beforeRender(MailerContext context) {
        Locale locale = context.locale();
        this.engine = this.engine.prepare(locale);
    }

    @Override
    protected String render(Map<String, Object> renderArgs) {
        ITemplate t = this.template(renderArgs);
        return t.render();
    }

    private ITemplate template(Map<String, Object> renderArgs) {
        if (this.inline) {
            TemplateClassManager tcm = this.engine.classes();
            TemplateClass tc = tcm.getByTemplate((Object)this.literal);
            if (null == tc) {
                tc = new TemplateClass(this.literal, this.engine, BasicRythm.INSTANCE);
            }
            ITemplate t = tc.asTemplate(this.engine);
            t.__setRenderArgs(renderArgs);
            return t;
        }
        return this.engine.getTemplate(this.literal, new Object[]{renderArgs});
    }

    public static RythmTemplate find(RythmEngine engine, String path) {
        ITemplateResource resource = engine.resourceManager().getResource(path);
        if (!resource.isValid()) {
            return null;
        }
        return new RythmTemplate(engine, path);
    }
}

