/*
 * Decompiled with CFR 0.152.
 */
package act.view.rythm;

import act.Act;
import act.app.AppByteCodeScannerBase;
import act.app.event.SysEventId;
import act.asm.AnnotationVisitor;
import act.asm.MethodVisitor;
import act.asm.Type;
import act.util.AsmTypes;
import act.util.ByteCodeVisitor;
import act.view.rythm.RythmView;
import org.osgl.$;
import org.osgl.util.S;
import org.rythmengine.extension.Transformer;

public class RythmTransformerScanner
extends AppByteCodeScannerBase {
    private static final String TRANSFORMER = Transformer.class.getName();

    @Override
    protected boolean shouldScan(String className) {
        return true;
    }

    @Override
    public ByteCodeVisitor byteCodeVisitor() {
        return new Visitor();
    }

    @Override
    public void scanFinished(String className) {
    }

    private class Visitor
    extends ByteCodeVisitor {
        boolean found;
        String className;

        private Visitor() {
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            if (!AsmTypes.isPublic(access)) {
                return;
            }
            this.className = Type.getObjectType((String)name).getClassName();
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (!this.found) {
                String className = Type.getType((String)desc).getClassName();
                if (S.eq((String)TRANSFORMER, (String)className)) {
                    this.found = true;
                }
            }
            return super.visitAnnotation(desc, visible);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (this.found) {
                return mv;
            }
            return new MethodVisitor(327680, mv){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    if (!Visitor.this.found) {
                        String className = Type.getType((String)desc).getClassName();
                        if (S.eq((String)TRANSFORMER, (String)className)) {
                            Visitor.this.found = true;
                        }
                    }
                    return super.visitAnnotation(desc, visible);
                }
            };
        }

        public void visitEnd() {
            super.visitEnd();
            if (this.found) {
                RythmTransformerScanner.this.app().jobManager().on(SysEventId.PRE_START, new Runnable(){

                    @Override
                    public void run() {
                        RythmView rythmView = (RythmView)Act.viewManager().view("rythm");
                        rythmView.registerTransformer(RythmTransformerScanner.this.app(), $.classForName((String)Visitor.this.className, (ClassLoader)RythmTransformerScanner.this.app().classLoader()));
                    }
                });
            }
        }
    }
}

