/*
 * Decompiled with CFR 0.152.
 */
package act.ws;

import act.app.ActionContext;
import act.app.App;
import act.util.ActContext;
import act.ws.WebSocketConnectionManager;
import act.ws.WebSocketConnectionRegistry;
import act.xio.WebSocketConnection;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgl.$;
import org.osgl.concurrent.ContextLocal;
import org.osgl.http.H;
import org.osgl.util.E;
import org.osgl.util.S;

public class WebSocketContext
extends ActContext.Base<WebSocketContext>
implements WebSocketConnection {
    private WebSocketConnection connection;
    private WebSocketConnectionManager manager;
    private ActionContext actionContext;
    private String url;
    private String stringMessage;
    private boolean isJson;
    private Map<String, List<String>> queryParams;
    private static final ContextLocal<WebSocketContext> _local = $.contextLocal();

    public WebSocketContext(String url, WebSocketConnection connection, WebSocketConnectionManager manager, ActionContext actionContext, App app) {
        super(app);
        this.url = url;
        this.connection = (WebSocketConnection)$.notNull((Object)connection);
        this.manager = (WebSocketConnectionManager)$.notNull((Object)manager);
        this.actionContext = (ActionContext)$.notNull((Object)actionContext);
        _local.set((Object)this);
    }

    public String url() {
        return this.url;
    }

    @Override
    public String sessionId() {
        return this.connection.sessionId();
    }

    @Override
    public String username() {
        return this.connection.username();
    }

    public WebSocketConnectionManager manager() {
        return this.manager;
    }

    public WebSocketConnection connection() {
        return this.connection;
    }

    public ActionContext actionContext() {
        return this.actionContext;
    }

    public WebSocketContext messageReceived(String receivedMessage) {
        this.stringMessage = S.string((Object)receivedMessage).trim();
        this.isJson = this.stringMessage.startsWith("{") || this.stringMessage.startsWith("]");
        this.tryParseQueryParams();
        return this;
    }

    public WebSocketContext tag(String label) {
        this.manager.tagRegistry().register(label, this.connection);
        return this;
    }

    public String stringMessage() {
        return this.stringMessage;
    }

    public boolean isJson() {
        return this.isJson;
    }

    public WebSocketContext sendToSelf(String message) {
        this.send(message);
        return this;
    }

    public WebSocketContext sendJsonToSelf(Object data) {
        this.send(JSON.toJSONString((Object)data));
        return this;
    }

    public WebSocketContext sendToPeers(String message) {
        return this.sendToPeers(message, false);
    }

    public WebSocketContext sendToPeers(String message, boolean excludeSelf) {
        return this.sendToConnections(message, this.url, this.manager.urlRegistry(), excludeSelf);
    }

    public WebSocketContext sendJsonToPeers(Object data) {
        return this.sendToPeers(JSON.toJSONString((Object)data));
    }

    public WebSocketContext sendJsonToPeers(Object data, boolean excludeSelf) {
        return this.sendToPeers(JSON.toJSONString((Object)data), excludeSelf);
    }

    public WebSocketContext sendToTagged(String message, String tag) {
        return this.sendToTagged(message, tag, false);
    }

    public WebSocketContext sendToTagged(String message, String tag, boolean excludeSelf) {
        return this.sendToConnections(message, tag, this.manager.tagRegistry(), excludeSelf);
    }

    public WebSocketContext sendJsonToTagged(Object data, String tag) {
        return this.sendToTagged(JSON.toJSONString((Object)data), tag);
    }

    public WebSocketContext sendJsonToTagged(Object data, String tag, boolean excludeSelf) {
        return this.sendToTagged(JSON.toJSONString((Object)data), tag, excludeSelf);
    }

    public WebSocketContext sendToUser(String message, String username) {
        return this.sendToConnections(message, username, this.manager.usernameRegistry(), true);
    }

    public WebSocketContext sendJsonToUser(Object data, String username) {
        return this.sendToTagged(JSON.toJSONString((Object)data), username);
    }

    private WebSocketContext sendToConnections(String message, String key, WebSocketConnectionRegistry registry, boolean excludeSelf) {
        for (WebSocketConnection conn : registry.get(key)) {
            if (excludeSelf && this.connection == conn) continue;
            conn.send(message);
        }
        return this;
    }

    @Override
    public void send(String message) {
        this.connection.send(message);
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public boolean closed() {
        return this.connection.closed();
    }

    private void tryParseQueryParams() {
        String[] sa;
        this.queryParams = new HashMap<String, List<String>>();
        ArrayList<String> stringMessageList = new ArrayList<String>();
        stringMessageList.add(this.stringMessage);
        this.queryParams.put("_body", stringMessageList);
        if (this.isJson) {
            return;
        }
        for (String si : sa = this.stringMessage.split("&")) {
            String[] pair = si.split("=");
            if (pair.length != 2) continue;
            String key = pair[0];
            String val = pair[1];
            List<String> list = this.queryParams.get(key);
            if (null == list) {
                list = new ArrayList<String>();
                this.queryParams.put(key, list);
            }
            list.add(val);
        }
    }

    @Override
    public WebSocketContext accept(H.Format fmt) {
        throw E.unsupport();
    }

    @Override
    public H.Format accept() {
        throw E.unsupport();
    }

    @Override
    public String methodPath() {
        throw E.unsupport();
    }

    public Set<String> paramKeys() {
        return this.queryParams.keySet();
    }

    public String paramVal(String key) {
        List<String> vals = this.queryParams.get(key);
        return null == vals || vals.isEmpty() ? null : vals.get(0);
    }

    public String[] paramVals(String key) {
        List<String> vals = this.queryParams.get(key);
        return null == vals ? new String[]{} : vals.toArray(new String[vals.size()]);
    }

    public static WebSocketContext current() {
        return (WebSocketContext)_local.get();
    }

    public static void current(WebSocketContext ctx) {
        _local.set((Object)ctx);
    }
}

