/*
 * Decompiled with CFR 0.152.
 */
package act.xio.undertow;

import io.undertow.util.HttpString;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class HttpStringCache {
    static final HttpStringCache HEADER;
    private final ConcurrentMap<String, HttpString> lookup = new ConcurrentHashMap<String, HttpString>();

    HttpStringCache() {
    }

    HttpString get(String s) {
        HttpString hs = (HttpString)this.lookup.get(s);
        if (null == hs) {
            hs = new HttpString(s);
            this.lookup.putIfAbsent(s, hs);
        }
        return hs;
    }

    static {
        HttpStringCache cache = HEADER = new HttpStringCache();
        cache.get("Accept");
        cache.get("Access-Control-Allow-Origin");
        cache.get("Access-Control-Allow-Methods");
        cache.get("Access-Control-Allow-Headers");
        cache.get("Access-Control-Allow-Credentials");
        cache.get("Access-Control-Expose-Headers");
        cache.get("Access-Control-Max-Age");
        cache.get("Access-Control-Request-Method");
        cache.get("Access-Control-Request-Headers");
        cache.get("Authorization");
        cache.get("Content-Disposition");
        cache.get("Content-Encoding");
        cache.get("Content-Length");
        cache.get("Content-Security-Policy");
        cache.get("Content-Type");
        cache.get("Cookie");
        cache.get("Date");
        cache.get("Etag");
        cache.get("Expires");
        cache.get("Host");
        cache.get("HTTP_CLIENT_IP");
        cache.get("HTTP_X_FORWARDED_FOR");
        cache.get("If-Match");
        cache.get("If-Modified-Since");
        cache.get("If-None-Match");
        cache.get("If-Range");
        cache.get("If-Unmodified-Since");
        cache.get("Last-Modified");
        cache.get("Origin");
        cache.get("Pragma");
        cache.get("Range");
        cache.get("Referer");
        cache.get("Sec-Websocket-Key1");
        cache.get("Sec-Websocket-Key2");
        cache.get("Sec-Websocket-Location");
        cache.get("Sec-Websocket-Rrigin");
        cache.get("Sec-Websocket-Protocol");
        cache.get("Sec-Websocket-Version");
        cache.get("Sec-Websocket-Key");
        cache.get("Sec-Websocket-Accept");
        cache.get("Server");
        cache.get("Set-Cookie");
        cache.get("Set-Cookie2");
        cache.get("Upgrade");
        cache.get("User-Agent");
        cache.get("Websocket-Location");
        cache.get("Webwocket-Origin");
        cache.get("Websocket-Protocol");
        cache.get("WWW-Authenticate");
        cache.get("X-Requested-With");
        cache.get("X-Forwarded-Host");
        cache.get("X-Forwarded-For");
        cache.get("X-Forwarded-Proto");
        cache.get("X-Forwarded-Ssl");
        cache.get("X-Http-Method-Override");
        cache.get("X-Url-Scheme");
        cache.get("X-Xsrf-Token");
    }
}

