/*
 * Decompiled with CFR 0.152.
 */
package act.xio.undertow;

import act.xio.undertow.UndertowResponse;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import org.osgl.util.Output;

public class UndertowResponseOutput
implements Output {
    private UndertowResponse resp;

    public UndertowResponseOutput(UndertowResponse resp) {
        this.resp = resp;
    }

    public void open() {
        this.resp.beforeWritingContent();
    }

    public void close() {
        this.resp.afterWritingContent();
    }

    public void flush() {
    }

    public Output append(CharSequence csq) {
        this.resp.writeContentPart(csq.toString());
        return this;
    }

    public Output append(CharSequence csq, int start, int end) {
        return this.append(csq.subSequence(start, end));
    }

    public Output append(char c) {
        return this.append("" + c);
    }

    public Output append(byte[] bytes) {
        return this.append(ByteBuffer.wrap(bytes));
    }

    public Output append(byte[] bytes, int start, int end) {
        return this.append(ByteBuffer.wrap(bytes, start, end));
    }

    public Output append(byte b) {
        return this.append(new byte[b]);
    }

    public Output append(ByteBuffer buffer) {
        this.resp.writeContentPart(buffer);
        return this;
    }

    public OutputStream asOutputStream() {
        return Output.Adaptors.asOutputStream((Output)this);
    }

    public Writer asWriter() {
        return Output.Adaptors.asWriter((Output)this);
    }
}

