/*
 * Decompiled with CFR 0.152.
 */
package act.xio.undertow;

import act.Act;
import act.app.ActionContext;
import act.controller.meta.ActionMethodMetaInfo;
import act.view.ActErrorResult;
import act.ws.WebSocketCloseEvent;
import act.ws.WebSocketConnectEvent;
import act.ws.WebSocketConnectionManager;
import act.ws.WebSocketContext;
import act.xio.WebSocketConnectionHandler;
import act.xio.undertow.UndertowRequest;
import act.xio.undertow.UndertowWebSocketConnection;
import io.undertow.Handlers;
import io.undertow.server.HttpServerExchange;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import org.xnio.ChannelListener;

class UndertowWebSocketConnectionHandler
extends WebSocketConnectionHandler {
    UndertowWebSocketConnectionHandler(WebSocketConnectionManager manager) {
        super(manager);
    }

    UndertowWebSocketConnectionHandler(ActionMethodMetaInfo method, WebSocketConnectionManager manager) {
        super(method, manager);
    }

    @Override
    public void handle(final ActionContext context) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("handle websocket connection request to %s", new Object[]{context.req().url()});
        }
        final UndertowRequest req = (UndertowRequest)context.req();
        HttpServerExchange exchange = req.exchange();
        try {
            Handlers.websocket((WebSocketConnectionCallback)new WebSocketConnectionCallback(){

                public void onConnect(WebSocketHttpExchange exchange, WebSocketChannel channel) {
                    final UndertowWebSocketConnection connection = new UndertowWebSocketConnection(channel, context.session());
                    channel.setAttribute("act_conn", (Object)connection);
                    UndertowWebSocketConnectionHandler.this.connectionManager.registerNewConnection(connection, context);
                    final WebSocketContext wsCtx = new WebSocketContext(req.url(), connection, UndertowWebSocketConnectionHandler.this.connectionManager, context, UndertowWebSocketConnectionHandler.this.connectionManager.app());
                    if (UndertowWebSocketConnectionHandler.this.logger.isTraceEnabled()) {
                        UndertowWebSocketConnectionHandler.this.logger.trace("websocket context[%s] created for %s", new Object[]{connection.sessionId(), context.req().url()});
                    }
                    channel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

                        protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
                            WebSocketContext.current(wsCtx);
                            String payload = message.getData();
                            if (UndertowWebSocketConnectionHandler.this.logger.isTraceEnabled()) {
                                UndertowWebSocketConnectionHandler.this.logger.trace("websocket message received: %s", new Object[]{payload});
                            }
                            wsCtx.messageReceived(payload);
                            UndertowWebSocketConnectionHandler.this.invoke(wsCtx);
                        }

                        protected void onClose(WebSocketChannel webSocketChannel, StreamSourceFrameChannel channel) throws IOException {
                            if (UndertowWebSocketConnectionHandler.this.logger.isTraceEnabled()) {
                                UndertowWebSocketConnectionHandler.this.logger.trace("websocket closed: ", new Object[]{connection.sessionId()});
                            }
                            WebSocketContext.current(wsCtx);
                            super.onClose(webSocketChannel, channel);
                            connection.destroy();
                            context.app().eventBus().emit(new WebSocketCloseEvent(wsCtx), new Object[0]);
                        }
                    });
                    channel.resumeReceives();
                    Act.eventBus().emit(new WebSocketConnectEvent(wsCtx), new Object[0]);
                }
            }).handleRequest(exchange);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw ActErrorResult.of(e);
        }
    }
}

