/*
 * Decompiled with CFR 0.152.
 */
package act;

import act.BytecodeEnhancerManager;
import act.Destroyable;
import act.app.App;
import act.app.AppClassLoader;
import act.app.AppManager;
import act.app.AppScanner;
import act.app.DevModeClassLoader;
import act.app.RequestRefreshClassLoader;
import act.app.RequestServerRestart;
import act.app.event.SysEventId;
import act.app.util.NamedPort;
import act.boot.BootstrapClassLoader;
import act.boot.PluginClassProvider;
import act.boot.app.FullStackAppBootstrapClassLoader;
import act.boot.app.RunApp;
import act.conf.ActConfLoader;
import act.conf.ActConfig;
import act.conf.AppConfig;
import act.conf.AppConfigKey;
import act.conf.ConfLoader;
import act.controller.meta.ActionMethodMetaInfo;
import act.controller.meta.CatchMethodMetaInfo;
import act.controller.meta.InterceptorMethodMetaInfo;
import act.crypto.AppCrypto;
import act.db.DbManager;
import act.event.ActEvent;
import act.event.ActEventListener;
import act.event.EventBus;
import act.handler.RequestHandlerBase;
import act.handler.SimpleRequestHandler;
import act.handler.builtin.controller.AfterInterceptor;
import act.handler.builtin.controller.BeforeInterceptor;
import act.handler.builtin.controller.ControllerAction;
import act.handler.builtin.controller.ExceptionInterceptor;
import act.handler.builtin.controller.FinallyInterceptor;
import act.handler.builtin.controller.impl.ReflectedHandlerInvoker;
import act.inject.DependencyInjector;
import act.internal.util.AppDescriptor;
import act.job.JobManager;
import act.metric.MetricPlugin;
import act.metric.SimpleMetricPlugin;
import act.plugin.AppServicePluginManager;
import act.plugin.GenericPluginManager;
import act.plugin.Plugin;
import act.plugin.PluginScanner;
import act.route.RouteSource;
import act.sys.Env;
import act.util.AppCodeScannerPluginManager;
import act.util.Banner;
import act.util.ClassInfoRepository;
import act.util.SysProps;
import act.view.ViewManager;
import act.xio.Network;
import act.xio.NetworkHandler;
import act.xio.undertow.UndertowNetwork;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.osgl.$;
import org.osgl.Lang;
import org.osgl.cache.CacheService;
import org.osgl.exception.NotAppliedException;
import org.osgl.exception.UnexpectedException;
import org.osgl.http.H;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;
import org.osgl.util.OS;
import org.osgl.util.S;
import osgl.version.Version;
import osgl.version.Versioned;

@Versioned
public final class Act {
    public static final Version VERSION = Version.of(Act.class);
    public static final Logger LOGGER = LogManager.get(Act.class);
    public static final String PROP_APP_JAR_FILE = "act_app_jar_file";
    private static final String ATTR_APP_JAR = "App-Jar";
    private static ActConfig conf;
    private static Mode mode;
    private static String nodeGroup;
    private static AppManager appManager;
    private static ViewManager viewManager;
    private static Network network;
    private static MetricPlugin metricPlugin;
    private static BytecodeEnhancerManager enhancerManager;
    private static AppCodeScannerPluginManager scannerPluginManager;
    private static DbManager dbManager;
    private static GenericPluginManager pluginManager;
    private static AppServicePluginManager appPluginManager;
    private static Map<String, Plugin> genericPluginRegistry;
    private static Map<Class<? extends ActEvent>, List<ActEventListener>> listeners;

    public static Mode mode() {
        return mode;
    }

    public static boolean isProd() {
        return mode.isProd();
    }

    public static boolean isDev() {
        return mode.isDev();
    }

    public static String profile() {
        return ConfLoader.confSetName();
    }

    public static String nodeGroup() {
        return nodeGroup;
    }

    public static ActConfig conf() {
        return conf;
    }

    public static ClassInfoRepository classInfoRepository() {
        ClassLoader cl = Act.class.getClassLoader();
        if (cl instanceof BootstrapClassLoader) {
            return ((BootstrapClassLoader)cl).classInfoRepository();
        }
        LOGGER.warn("Class loader [%s] of Act is not a ActClassLoader", new Object[]{cl});
        return null;
    }

    public static List<Class<?>> pluginClasses() {
        ClassLoader cl = Act.class.getClassLoader();
        if (cl instanceof PluginClassProvider) {
            return ((PluginClassProvider)((Object)cl)).pluginClasses();
        }
        LOGGER.warn("Class loader [%s] of Act is not a PluginClassProvider", new Object[]{cl});
        return C.list();
    }

    public static AppServicePluginManager appServicePluginManager() {
        return appPluginManager;
    }

    public static DbManager dbManager() {
        return dbManager;
    }

    public static BytecodeEnhancerManager enhancerManager() {
        return enhancerManager;
    }

    public static GenericPluginManager pluginManager() {
        return pluginManager;
    }

    public static MetricPlugin metricPlugin() {
        return metricPlugin;
    }

    public static AppCodeScannerPluginManager scannerPluginManager() {
        return scannerPluginManager;
    }

    public static AppManager applicationManager() {
        return appManager;
    }

    public static ViewManager viewManager() {
        return viewManager;
    }

    public static Network network() {
        return network;
    }

    public static void registerPlugin(Plugin plugin) {
        genericPluginRegistry.put(plugin.getClass().getCanonicalName().intern(), plugin);
    }

    public static <T extends Plugin> T registeredPlugin(Class<T> type) {
        return (T)genericPluginRegistry.get(type.getCanonicalName().intern());
    }

    public static void startup(AppDescriptor descriptor) {
        Act.processEnvironment(descriptor);
        Banner.print(descriptor);
        Act.loadConfig();
        Act.initMetricPlugin();
        Act.initPluginManager();
        Act.initAppServicePluginManager();
        Act.initDbManager();
        Act.initEnhancerManager();
        Act.initViewManager();
        Act.initAppCodeScannerPluginManager();
        Act.loadPlugins();
        Act.enhancerManager().registered();
        Act.initNetworkLayer();
        Act.initApplicationManager();
        LOGGER.info("loading application(s) ...");
        appManager.loadSingleApp(descriptor);
        Act.startNetworkLayer();
        Thread.currentThread().setContextClassLoader(Act.class.getClassLoader());
        App app = Act.app();
        if (null == app) {
            Act.shutdownNetworkLayer();
            throw new UnexpectedException("App not found. Please make sure your app start directory is correct");
        }
        Act.emit(SysEventId.ACT_START);
        Act.writePidFile();
    }

    public static void shutdown(App app) {
        if (null == appManager) {
            return;
        }
        if (!appManager.unload(app)) {
            app.destroy();
        }
        Act.shutdownAct();
    }

    public static RequestServerRestart requestRestart() {
        E.illegalStateIf((!Act.isDev() ? 1 : 0) != 0);
        throw new RequestServerRestart();
    }

    public static RequestRefreshClassLoader requestRefreshClassLoader() {
        E.illegalStateIf((!Act.isDev() ? 1 : 0) != 0);
        throw RequestRefreshClassLoader.INSTANCE;
    }

    public static void hook(App app) {
        int port = app.config().httpPort();
        NetworkHandler networkHandler = new NetworkHandler(app);
        network.register(port, false, networkHandler);
        if (app.config().supportSsl()) {
            network.register(Act.appConfig().httpsPort(), true, networkHandler);
        }
        List<NamedPort> portList = app.config().namedPorts();
        for (NamedPort np : portList) {
            network.register(np.port(), false, new NetworkHandler(app, np));
        }
    }

    public static synchronized void trigger(ActEvent<?> event) {
        List<ActEventListener> list = listeners.get(event.getClass());
        if (null != list) {
            for (ActEventListener l : list) {
                try {
                    l.on(event);
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e, "error calling act event listener %s on event %s", new Object[]{l.id(), event});
                }
            }
        }
    }

    public static synchronized <T extends ActEvent> void registerEventListener(Class<T> eventClass, ActEventListener<T> listener) {
        List<ActEventListener> list = listeners.get(eventClass);
        if (null == list) {
            list = new ArrayList<ActEventListener>();
            listeners.put(eventClass, list);
        }
        if (!list.contains(listener)) {
            list.add(listener);
        }
    }

    public static String cuid() {
        return App.instance().cuid();
    }

    public static AppCrypto crypto() {
        return Act.app().crypto();
    }

    public static App app() {
        return App.instance();
    }

    public static Version appVersion() {
        return Act.app().version();
    }

    public static AppConfig appConfig() {
        return App.instance().config();
    }

    @Deprecated
    public static <T> T singleton(Class<T> singletonClass) {
        return App.instance().singleton(singletonClass);
    }

    public static CacheService cache() {
        return App.instance().cache();
    }

    public static void emit(SysEventId sysEvent) {
        App.instance().emit(sysEvent);
    }

    public static void trigger(SysEventId sysEventId) {
        Act.emit(sysEventId);
    }

    public static EventBus eventBus() {
        return App.instance().eventBus();
    }

    public static JobManager jobManager() {
        return App.instance().jobManager();
    }

    public static <DI extends DependencyInjector> DI injector() {
        return App.instance().injector();
    }

    public static Class<?> appClassForName(String className) {
        return Act.app().classForName(className);
    }

    public static <T> T getInstance(String className) {
        return Act.app().getInstance(className);
    }

    public static <T> T getInstance(Class<? extends T> clz) {
        return Act.app().getInstance(clz);
    }

    public static void get(String url, SimpleRequestHandler handler) {
        Act.get(url, RequestHandlerBase.wrap(handler));
    }

    public static void getNonblock(String url, SimpleRequestHandler handler) {
        Act.get(url, RequestHandlerBase.wrap(handler).setExpress());
    }

    public static void post(String url, SimpleRequestHandler handler) {
        Act.post(url, RequestHandlerBase.wrap(handler));
    }

    public static void put(String url, SimpleRequestHandler handler) {
        Act.put(url, RequestHandlerBase.wrap(handler));
    }

    public static void delete(String url, SimpleRequestHandler handler) {
        Act.delete(url, RequestHandlerBase.wrap(handler));
    }

    public static void get(String url, RequestHandlerBase handler) {
        Act.app().router().addMapping(H.Method.GET, (CharSequence)url, handler, RouteSource.APP_CONFIG);
    }

    public static void post(String url, RequestHandlerBase handler) {
        Act.app().router().addMapping(H.Method.POST, (CharSequence)url, handler, RouteSource.APP_CONFIG);
    }

    public static void put(String url, RequestHandlerBase handler) {
        Act.app().router().addMapping(H.Method.PUT, (CharSequence)url, handler, RouteSource.APP_CONFIG);
    }

    public static void delete(String url, RequestHandlerBase handler) {
        Act.app().router().addMapping(H.Method.DELETE, (CharSequence)url, handler, RouteSource.APP_CONFIG);
    }

    public static void start() throws Exception {
        Act.bootstrap(AppDescriptor.of(Act.getCallerClass()));
    }

    public static void start(String appName) throws Exception {
        Act.bootstrap(AppDescriptor.of(appName, Act.getCallerClass()));
    }

    public static void start(String appName, String scanPackage) throws Exception {
        Act.bootstrap(AppDescriptor.of(appName, scanPackage));
    }

    public static void start(String appName, Class<?> anyAppClass) throws Exception {
        Act.bootstrap(AppDescriptor.of(appName, anyAppClass));
    }

    public static void start(Class<?> anyAppClass) throws Exception {
        Act.bootstrap(AppDescriptor.of(anyAppClass));
    }

    public static void start(String appName, Class<?> anyAppClass, Version appVersion) throws Exception {
        Act.bootstrap(AppDescriptor.of(appName, anyAppClass, appVersion));
    }

    public static void start(String appName, String scanPackage, Version appVersion) throws Exception {
        Act.bootstrap(AppDescriptor.of(appName, scanPackage, appVersion));
    }

    static int classCacheSize() {
        return ((FullStackAppBootstrapClassLoader)Act.class.getClassLoader()).libBCSize();
    }

    private static String appJar() {
        URL url = Act.class.getClassLoader().getResource("META-INF/MANIFEST.MF");
        if (null != url) {
            try {
                Manifest manifest = new Manifest(url.openStream());
                Attributes attributes = manifest.getMainAttributes();
                if (null != attributes) {
                    return attributes.getValue(ATTR_APP_JAR);
                }
            }
            catch (IOException e) {
                LOGGER.warn((Throwable)e, "cannot open manifest resource: %s", new Object[]{url});
            }
        }
        return null;
    }

    private static void processEnvironment(AppDescriptor descriptor) {
        boolean traceEnabled = LOGGER.isTraceEnabled();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        S.List cp = S.fastSplit((String)runtimeMXBean.getClassPath(), (String)File.pathSeparator);
        boolean hasClassesDir = false;
        String artifactId = descriptor.getVersion().getArtifactId();
        String appJar = Act.appJar();
        String appJarFile = null;
        for (String cpItem : cp) {
            if (!cpItem.endsWith(".jar")) {
                if (traceEnabled) {
                    LOGGER.trace("found class path that are not jar file: %s", new Object[]{cpItem});
                }
                hasClassesDir = true;
                break;
            }
            if (null != appJarFile) continue;
            if (null != appJar && cpItem.contains(appJar)) {
                appJarFile = cpItem;
                continue;
            }
            if (!cpItem.contains(artifactId)) continue;
            appJarFile = cpItem;
        }
        String s = System.getProperty("app.mode");
        if (!hasClassesDir) {
            mode = Mode.PROD;
            if (null != appJarFile) {
                System.setProperty(PROP_APP_JAR_FILE, appJarFile);
            }
        } else if (null != s) {
            mode = Mode.valueOfIgnoreCase(s);
            if (traceEnabled) {
                LOGGER.trace("set app mode to user specified: %s", new Object[]{s});
            }
        } else {
            String profile = SysProps.get(AppConfigKey.PROFILE.key());
            if (S.eq((String)"prod", (String)profile, (int)4096)) {
                mode = Mode.PROD;
                if (traceEnabled) {
                    LOGGER.trace("set app mode to prod based on profile setting");
                }
            } else if (S.eq((String)"dev", (String)profile, (int)4096)) {
                mode = Mode.DEV;
                if (traceEnabled) {
                    LOGGER.trace("set app mode to dev based on profile setting");
                }
            } else {
                Mode mode = Act.mode = hasClassesDir ? Mode.DEV : Mode.PROD;
                if (traceEnabled) {
                    LOGGER.trace("set app mode to system determined: %s", new Object[]{Act.mode});
                }
            }
        }
        if (null != (s = System.getProperty("app.nodeGroup"))) {
            nodeGroup = s;
            if (traceEnabled) {
                LOGGER.trace("set node group to %s", new Object[]{s});
            }
        }
    }

    private static void loadConfig() {
        LOGGER.debug("loading configuration ...");
        String s = SysProps.get("act.mode");
        if (null != s) {
            mode = Mode.valueOfIgnoreCase(s);
        }
        LOGGER.debug("Act starts in %s mode", new Object[]{mode});
        conf = (ActConfig)new ActConfLoader().load(null);
    }

    private static void unloadConfig() {
        conf = null;
    }

    private static void loadPlugins() {
        LOGGER.debug("scanning plugins ...");
        long ts = $.ms();
        new PluginScanner().scan();
        LOGGER.debug("plugin scanning finished in %sms", new Object[]{$.ms() - ts});
    }

    private static void unloadPlugins() {
        new PluginScanner().unload();
    }

    private static void initViewManager() {
        LOGGER.debug("initializing view manager ...");
        viewManager = new ViewManager();
    }

    private static void destroyViewManager() {
        if (null != viewManager) {
            viewManager.destroy();
            viewManager = null;
        }
    }

    private static void initMetricPlugin() {
        LOGGER.debug("initializing metric plugin ...");
        metricPlugin = new SimpleMetricPlugin();
    }

    private static void destroyMetricPlugin() {
        if (null != metricPlugin) {
            Destroyable.Util.tryDestroy(metricPlugin);
            metricPlugin = null;
        }
    }

    private static void initPluginManager() {
        LOGGER.debug("initializing generic plugin manager ...");
        pluginManager = new GenericPluginManager();
    }

    private static void destroyPluginManager() {
        if (null != pluginManager) {
            pluginManager.destroy();
            pluginManager = null;
        }
    }

    private static void initAppServicePluginManager() {
        LOGGER.debug("initializing app service plugin manager ...");
        appPluginManager = new AppServicePluginManager();
    }

    private static void destroyAppServicePluginManager() {
        if (null != appPluginManager) {
            appPluginManager.destroy();
            appPluginManager = null;
        }
    }

    private static void initDbManager() {
        LOGGER.debug("initializing db manager ...");
        dbManager = new DbManager();
    }

    private static void destroyDbManager() {
        if (null != dbManager) {
            dbManager.destroy();
            dbManager = null;
        }
    }

    private static void initAppCodeScannerPluginManager() {
        LOGGER.debug("initializing app code scanner plugin manager ...");
        scannerPluginManager = new AppCodeScannerPluginManager();
    }

    private static void destroyAppCodeScannerPluginManager() {
        if (null != scannerPluginManager) {
            scannerPluginManager.destroy();
            scannerPluginManager = null;
        }
    }

    static void initEnhancerManager() {
        LOGGER.debug("initializing byte code enhancer manager ...");
        enhancerManager = new BytecodeEnhancerManager();
    }

    private static void destroyEnhancerManager() {
        if (null != enhancerManager) {
            enhancerManager.destroy();
            enhancerManager = null;
        }
    }

    private static void initNetworkLayer() {
        LOGGER.debug("initializing network layer ...");
        network = new UndertowNetwork();
    }

    private static void destroyNetworkLayer() {
        if (null != network) {
            network.destroy();
            network = null;
        }
    }

    private static void startNetworkLayer() {
        if (network.isDestroyed()) {
            return;
        }
        LOGGER.debug("starting network layer ...");
        network.start();
    }

    private static void shutdownNetworkLayer() {
        LOGGER.debug("shutting down network layer ...");
        network.shutdown();
    }

    protected static void initApplicationManager() {
        LOGGER.debug("initializing application manager ...");
        appManager = AppManager.create();
    }

    private static Class<?> getCallerClass() {
        StackTraceElement[] sa = new RuntimeException().getStackTrace();
        E.unexpectedIf((sa.length < 3 ? 1 : 0) != 0, (String)"Whoops!", (Object[])new Object[0]);
        StackTraceElement ste = sa[2];
        String className = ste.getClassName();
        if ("act.Act$start".equals(className)) {
            ste = sa[6];
            className = ste.getClassName();
        }
        E.unexpectedIf((!className.contains(".") ? 1 : 0) != 0, (String)"The main class must have package name to use Act", (Object[])new Object[0]);
        return $.classForName((String)className);
    }

    private static void bootstrap(AppDescriptor appDescriptor) throws Exception {
        long ts = $.ms();
        String profile = SysProps.get(AppConfigKey.PROFILE.key());
        profile = S.blank((String)profile) ? "" : "using profile[" + profile + "]";
        String packageName = appDescriptor.getPackageName();
        LOGGER.debug("run fullstack application with package[%s] %s", new Object[]{packageName, profile});
        String SCAN_PACKAGE = AppConfigKey.SCAN_PACKAGE.key();
        if (S.notBlank((String)packageName)) {
            System.setProperty(SCAN_PACKAGE, packageName);
        }
        FullStackAppBootstrapClassLoader classLoader = new FullStackAppBootstrapClassLoader(RunApp.class.getClassLoader());
        Thread.currentThread().setContextClassLoader(classLoader);
        Class<?> actClass = classLoader.loadClass("act.Act");
        Method m = actClass.getDeclaredMethod("startup", byte[].class);
        m.setAccessible(true);
        $.invokeStatic((Method)m, (Object[])new Object[]{appDescriptor.toByteArray()});
        int port = (Integer)$.invokeStatic(actClass, (String)"httpPort", (Object[])new Object[0]);
        LOGGER.info("app is ready at: http://%s:%s", new Object[]{Act.getLocalIpAddr(), port});
        LOGGER.info("it takes %sms to start the app\n", new Object[]{$.ms() - ts});
    }

    public static int httpPort() {
        return Act.app().config().httpPort();
    }

    private static void shutdownAct() {
        Act.clearPidFile();
        Act.shutdownNetworkLayer();
        Act.destroyApplicationManager();
        Act.unloadPlugins();
        Act.destroyAppCodeScannerPluginManager();
        Act.destroyViewManager();
        Act.destroyEnhancerManager();
        Act.destroyDbManager();
        Act.destroyAppServicePluginManager();
        Act.destroyPluginManager();
        Act.destroyMetricPlugin();
        Act.unloadConfig();
        Act.destroyNetworkLayer();
    }

    private static void destroyApplicationManager() {
        if (null != appManager) {
            appManager.destroy();
            appManager = null;
        }
    }

    private static void writePidFile() {
        String pid;
        String pidFile = Act.pidFile();
        OS os = OS.get();
        if (os.isLinux()) {
            pid = Env.PID.get();
        } else {
            try {
                String name = ManagementFactory.getRuntimeMXBean().getName();
                int pos = name.indexOf(64);
                if (pos <= 0) {
                    LOGGER.warn("Write pid file not supported on non-linux system");
                    return;
                }
                pid = name.substring(0, pos);
            }
            catch (Exception e) {
                LOGGER.warn("Write pid file not supported on non-linux system");
                return;
            }
        }
        try {
            IO.writeContent((CharSequence)pid, (File)new File(pidFile));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Act.clearPidFile();
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e, "Error writing pid file: %s", new Object[]{e.getMessage()});
        }
    }

    private static void clearPidFile() {
        String pidFile = Act.pidFile();
        try {
            File file = new File(pidFile);
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e, "Error delete pid file: %s", new Object[]{pidFile});
        }
    }

    private static String pidFile() {
        String pidFile = System.getProperty("pidfile");
        if (S.blank((String)pidFile)) {
            pidFile = "act.pid";
        }
        return pidFile;
    }

    private static void startup(byte[] appDescriptor) {
        AppDescriptor descriptor = AppDescriptor.deserializeFrom(appDescriptor);
        Act.startup(descriptor);
    }

    private static String getLocalIpAddr() {
        try {
            for (NetworkInterface ni : C.list(NetworkInterface.getNetworkInterfaces())) {
                if (ni.isLoopback() || !ni.isUp() || ni.isVirtual()) continue;
                for (InetAddress addr : C.list(ni.getInetAddresses())) {
                    if (addr.isMulticastAddress() || addr.isLoopbackAddress() || addr.isLinkLocalAddress() || addr instanceof Inet6Address) continue;
                    return addr.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn((Throwable)e, "cannot determine local ip address");
            return "localhost";
        }
        LOGGER.warn("cannot determine local ip address");
        return "localhost";
    }

    static {
        mode = Mode.PROD;
        nodeGroup = "";
        genericPluginRegistry = new HashMap<String, Plugin>();
        listeners = new HashMap<Class<? extends ActEvent>, List<ActEventListener>>();
    }

    public static enum F {

        public static final Lang.F0<Mode> MODE_ACCESSOR = new Lang.F0<Mode>(){

            public Mode apply() throws NotAppliedException, Lang.Break {
                return mode;
            }
        };
    }

    public static enum Mode {
        PROD,
        DEV{

            @Override
            public AppScanner appScanner() {
                return AppScanner.SINGLE_APP_SCANNER;
            }

            @Override
            public AppClassLoader classLoader(App app) {
                return new DevModeClassLoader(app);
            }
        };

        private final String confPrefix = "%" + this.name().toLowerCase() + ".";

        public boolean isDev() {
            return DEV == this;
        }

        public boolean isProd() {
            return PROD == this;
        }

        public String configKey(String key) {
            return this.confPrefix + key;
        }

        public AppScanner appScanner() {
            return AppScanner.DEF_SCANNER;
        }

        public AppClassLoader classLoader(App app) {
            return new AppClassLoader(app);
        }

        public ControllerAction createRequestHandler(ActionMethodMetaInfo action, App app) {
            return ReflectedHandlerInvoker.createControllerAction(action, app);
        }

        public BeforeInterceptor createBeforeInterceptor(InterceptorMethodMetaInfo before, App app) {
            return ReflectedHandlerInvoker.createBeforeInterceptor(before, app);
        }

        public AfterInterceptor createAfterInterceptor(InterceptorMethodMetaInfo after, App app) {
            return ReflectedHandlerInvoker.createAfterInterceptor(after, app);
        }

        public ExceptionInterceptor createExceptionInterceptor(CatchMethodMetaInfo ex, App app) {
            return ReflectedHandlerInvoker.createExceptionInterceptor(ex, app);
        }

        public FinallyInterceptor createFinallyInterceptor(InterceptorMethodMetaInfo fin, App app) {
            return ReflectedHandlerInvoker.createFinannyInterceptor(fin, app);
        }

        public static Mode valueOfIgnoreCase(String mode) {
            return Mode.valueOf(mode.trim().toUpperCase());
        }
    }
}

