/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Act;
import act.app.App;
import act.app.CompilationException;
import act.app.DevModeClassLoader;
import act.app.Source;
import act.conf.AppConfig;
import act.metric.Metric;
import act.metric.Timer;
import act.util.DestroyableBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.osgl.$;
import org.osgl.util.E;
import org.osgl.util.S;

class AppCompiler
extends DestroyableBase {
    Map<String, Boolean> packagesCache = new HashMap<String, Boolean>();
    private DevModeClassLoader classLoader;
    private App app;
    private AppConfig conf;
    private CompilerOptions compilerOptions;
    private Metric metric;
    private INameEnvironment nameEnv = new INameEnvironment(){

        public NameEnvironmentAnswer findType(char[][] chars) {
            S.Buffer result = S.buffer();
            for (int i = 0; i < chars.length; ++i) {
                if (i != 0) {
                    result.append('.');
                }
                result.append(chars[i]);
            }
            return this.findType(result.toString());
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            S.Buffer result = S.buffer();
            for (int i = 0; i < packageName.length; ++i) {
                result.append(packageName[i]);
                result.append('.');
            }
            result.append(typeName);
            return this.findType(result.toString());
        }

        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            S.Buffer sb = S.buffer();
            if (parentPackageName != null) {
                for (char[] p : parentPackageName) {
                    sb.append(new String(p));
                    sb.append(".");
                }
            }
            sb.append(new String(packageName));
            String name = sb.toString();
            if (AppCompiler.this.packagesCache.containsKey(name)) {
                return AppCompiler.this.packagesCache.get(name);
            }
            if (AppCompiler.this.classLoader.source(name) != null) {
                AppCompiler.this.packagesCache.put(name, false);
                return false;
            }
            if (AppCompiler.this.classLoader.bytecode(name) != null) {
                AppCompiler.this.packagesCache.put(name, false);
                return false;
            }
            AppCompiler.this.packagesCache.put(name, true);
            return true;
        }

        public void cleanup() {
        }

        private NameEnvironmentAnswer findType(String type) {
            try {
                Source source;
                if (Act.isDev() && null != (source = AppCompiler.this.classLoader.source(type))) {
                    return new NameEnvironmentAnswer(source.compilationUnit(), null);
                }
                byte[] bytes = AppCompiler.this.classLoader.enhancedBytecode(type);
                if (bytes != null) {
                    ClassFileReader classFileReader = new ClassFileReader(bytes, type.toCharArray(), true);
                    return new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                }
                if (type.startsWith("org.osgl") || type.startsWith("java.") || type.startsWith("javax.")) {
                    return null;
                }
                if (Act.isDev()) {
                    return null;
                }
                source = AppCompiler.this.classLoader.source(type);
                if (null == source) {
                    return null;
                }
                return new NameEnvironmentAnswer(source.compilationUnit(), null);
            }
            catch (ClassFormatException e) {
                throw E.unexpected((Throwable)e);
            }
        }
    };
    private ICompilerRequestor requestor = new ICompilerRequestor(){

        public void acceptResult(CompilationResult result) {
            CategorizedProblem[] categorizedProblemArray;
            int n;
            int n2;
            if (result.hasErrors() && (n2 = 0) < (n = (categorizedProblemArray = result.getErrors()).length)) {
                Source src;
                CategorizedProblem problem = categorizedProblemArray[n2];
                char[][] caa = result.packageName;
                if (null == caa) {
                    caa = result.compilationUnit.getPackageName();
                }
                S.Buffer sb = S.buffer();
                if (null != caa) {
                    for (char[] ca : caa) {
                        sb.append(ca).append(".");
                    }
                }
                String className = sb.append(new String(problem.getOriginatingFileName())).toString();
                className = className.substring(0, className.length() - 5);
                String message = problem.getMessage();
                if (problem.getID() == 268435843) {
                    message = problem.getArguments()[0] + " cannot be resolved";
                }
                if (null != (src = AppCompiler.this.classLoader.source(className))) {
                    throw new CompilationException(src.file(), message, problem.getSourceLineNumber(), problem.getSourceStart(), problem.getSourceEnd());
                }
                throw new CompilationException(problem.getMessage());
            }
            ClassFile[] clazzFiles = result.getClassFiles();
            for (int i = 0; i < clazzFiles.length; ++i) {
                Source source;
                String name;
                ClassFile clazzFile = clazzFiles[i];
                char[][] compoundName = clazzFile.getCompoundName();
                StringBuffer clazzName = new StringBuffer();
                for (int j = 0; j < compoundName.length; ++j) {
                    if (j != 0) {
                        clazzName.append('.');
                    }
                    clazzName.append(compoundName[j]);
                }
                String name0 = name = clazzName.toString();
                if (name.contains("$")) {
                    name0 = S.beforeFirst((String)name, (String)"$");
                }
                if (null == (source = AppCompiler.this.classLoader.source(name0))) {
                    $.nil();
                    source = AppCompiler.this.classLoader.source(name0);
                }
                if (name != name0) {
                    String innerName = S.afterFirst((String)name, (String)"$");
                    source.compiled(innerName, clazzFile.getBytes());
                    continue;
                }
                source.compiled(clazzFile.getBytes());
            }
        }
    };

    AppCompiler(DevModeClassLoader classLoader) {
        this.classLoader = classLoader;
        this.app = classLoader.app();
        this.conf = this.app.config();
        this.metric = Act.metricPlugin().metric("act.classload.compile");
        this.configureCompilerOptions();
    }

    @Override
    protected void releaseResources() {
        this.packagesCache.clear();
        super.releaseResources();
    }

    private void configureCompilerOptions() {
        HashMap map = new HashMap();
        this.opt(map, "org.eclipse.jdt.core.compiler.problem.missingSerialVersion", "ignore");
        this.opt(map, "org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        this.opt(map, "org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        this.opt(map, "org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
        this.opt(map, "org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
        this.opt(map, "org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        this.opt(map, "org.eclipse.jdt.core.compiler.problem.unusedImport", "ignore");
        this.opt(map, "org.eclipse.jdt.core.encoding", "UTF-8");
        this.opt(map, "org.eclipse.jdt.core.compiler.processAnnotations", "enabled");
        this.opt(map, "org.eclipse.jdt.core.compiler.source", this.conf.sourceVersion());
        this.opt(map, "org.eclipse.jdt.core.compiler.codegen.targetPlatform", this.conf.targetVersion());
        this.opt(map, "org.eclipse.jdt.core.compiler.compliance", this.conf.sourceVersion());
        this.compilerOptions = new CompilerOptions(map);
    }

    private void opt(Map map, String key, String val) {
        map.put(key, val);
    }

    public void compile(Collection<Source> sources) {
        Timer timer = this.metric.startTimer("act:classload:compile:_all");
        int len = sources.size();
        ICompilationUnit[] compilationUnits = new ICompilationUnit[len];
        int i = 0;
        for (Source source : sources) {
            compilationUnits[i++] = source.compilationUnit();
        }
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitOnFirstError();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.ENGLISH);
        Compiler jdtCompiler = new Compiler(this.nameEnv, policy, this.compilerOptions, this.requestor, (IProblemFactory)problemFactory){

            protected void handleInternalException(Throwable e, CompilationUnitDeclaration ud, CompilationResult result) {
            }
        };
        jdtCompiler.compile(compilationUnits);
        timer.stop();
    }

    public void compile(String className) {
        Timer timer = this.metric.startTimer("act:classload:compile:" + className);
        ICompilationUnit[] compilationUnits = new ICompilationUnit[]{this.classLoader.source(className).compilationUnit()};
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.exitOnFirstError();
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.ENGLISH);
        Compiler jdtCompiler = new Compiler(this.nameEnv, policy, this.compilerOptions, this.requestor, (IProblemFactory)problemFactory){

            protected void handleInternalException(Throwable e, CompilationUnitDeclaration ud, CompilationResult result) {
            }
        };
        jdtCompiler.compile(compilationUnits);
        timer.stop();
    }
}

