/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Destroyable;
import act.app.App;
import act.app.AppService;
import act.event.EventBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.osgl.$;
import org.osgl.logging.LogManager;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.E;

@ApplicationScoped
class AppServiceRegistry {
    private static Logger logger = LogManager.get(AppServiceRegistry.class);
    private Map<Class<? extends AppService>, AppService> registry = new HashMap<Class<? extends AppService>, AppService>();
    private List<AppService> appendix = new ArrayList<AppService>();
    private App app;

    @Inject
    AppServiceRegistry(App app) {
        this.app = (App)$.notNull((Object)app);
    }

    synchronized void register(AppService service) {
        E.NPE((Object)service);
        Class<?> c = service.getClass();
        if (!this.registry.containsKey(c)) {
            this.registry.put(c, service);
            this.tryRegisterSingletonService(c, service);
        } else {
            E.illegalStateIf((boolean)this.isSingletonService(c), (String)"Singleton AppService[%s] cannot be re-registered", (Object[])new Object[]{c});
            if (!(service instanceof EventBus)) {
                logger.warn("Service type[%s] already registered", new Object[]{service.getClass()});
            }
            this.appendix.add(service);
        }
    }

    <T extends AppService<T>> T lookup(Class<T> serviceClass) {
        return (T)this.registry.get(serviceClass);
    }

    synchronized void bulkRegisterSingleton() {
        for (Map.Entry<Class<? extends AppService>, AppService> entry : this.registry.entrySet()) {
            if (!this.isSingletonService(entry.getKey())) continue;
            this.app.registerSingleton(entry.getKey(), entry.getValue());
        }
    }

    void destroy() {
        Destroyable.Util.destroyAll((Collection<? extends Destroyable>)C.list(this.appendix), ApplicationScoped.class);
        Destroyable.Util.destroyAll((Collection<? extends Destroyable>)C.list(this.registry.values()), ApplicationScoped.class);
        this.appendix.clear();
        this.registry.clear();
    }

    private boolean isSingletonService(Class<? extends AppService> c) {
        return c.getAnnotation(Singleton.class) != null;
    }

    private void tryRegisterSingletonService(Class<? extends AppService> c, AppService service) {
        if (this.isSingletonService(c)) {
            this.app.registerSingleton(c, service);
        }
    }
}

