/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Act;
import act.app.App;
import act.app.AppClassLoader;
import act.app.AppCompiler;
import act.app.AppSourceCodeScanner;
import act.app.ProjectLayout;
import act.app.Source;
import act.controller.meta.ControllerClassMetaInfo;
import act.metric.Timer;
import act.util.Files;
import act.util.FsChangeDetector;
import act.util.FsEvent;
import act.util.FsEventListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgl.Lang;
import org.osgl.exception.NotAppliedException;
import org.osgl.logging.L;
import org.osgl.logging.Logger;
import org.osgl.util.C;
import org.osgl.util.S;

public class DevModeClassLoader
extends AppClassLoader {
    private static final Logger logger = L.get(DevModeClassLoader.class);
    private Map<String, Source> sources = new HashMap<String, Source>();
    private final AppCompiler compiler;
    private List<FsChangeDetector> detectors = new ArrayList<FsChangeDetector>();
    private final FsEventListener sourceChangeListener = new FsEventListener(){

        @Override
        public void on(FsEvent ... events) {
            throw Act.requestRefreshClassLoader();
        }
    };
    private final FsEventListener libChangeListener = new FsEventListener(){

        @Override
        public void on(FsEvent ... events) {
            int len = events.length;
            if (len < 0) {
                return;
            }
            throw Act.requestRefreshClassLoader();
        }
    };
    private final FsEventListener confChangeListener = new ResourceChangeListener(){

        @Override
        public void on(FsEvent ... events) {
            super.on(events);
            throw Act.requestRestart();
        }
    };
    private final FsEventListener resourceChangeListener = new ResourceChangeListener();

    public DevModeClassLoader(App app) {
        super(app);
        this.compiler = new AppCompiler(this);
    }

    @Override
    protected void releaseResources() {
        this.sources.clear();
        this.compiler.destroy();
        super.releaseResources();
    }

    @Override
    public boolean isSourceClass(String className) {
        if (this.sources.containsKey(className)) {
            return true;
        }
        Class<?> clazz = this.app().classForName(className);
        return null != this.source(clazz);
    }

    public Source source(Class<?> clazz) {
        String className = clazz.getName();
        Source source = this.sources.get(className);
        if (null != source) {
            return source;
        }
        Class<?> enclosingClass = clazz.getEnclosingClass();
        return null == enclosingClass ? null : this.source(enclosingClass);
    }

    @Override
    public ControllerClassMetaInfo controllerClassMetaInfo(String controllerClassName) {
        return super.controllerClassMetaInfo(controllerClassName);
    }

    @Override
    protected void preload() {
        this.preloadSources();
        super.preload();
        this.setupFsChangeDetectors();
    }

    @Override
    protected void preloadClasses() {
    }

    @Override
    protected void scan() {
        super.scan();
        this.compileSources();
        this.scanSources();
    }

    @Override
    protected byte[] loadAppClassFromDisk(String name) {
        App app = this.app();
        List<File> srcRoots = app.sourceDirs();
        this.preloadSource(srcRoots, name);
        return this.bytecodeFromSource(name, true);
    }

    private void addSourceRoot(List<File> sourceRoots, File base, ProjectLayout layout) {
        if (null != base && base.isDirectory()) {
            sourceRoots.add(layout.source(base));
        }
    }

    @Override
    protected byte[] appBytecode(String name, boolean compileSource) {
        byte[] bytecode = super.appBytecode(name, compileSource);
        return null == bytecode && compileSource ? this.bytecodeFromSource(name, compileSource) : bytecode;
    }

    public Source source(String className) {
        if (className.contains("$")) {
            String name0 = S.before((String)className, (String)"$");
            return this.sources.get(name0);
        }
        return this.sources.get(className);
    }

    private void preloadSources() {
        List<File> sourceRoots = this.app().allSourceDirs(true);
        for (final File sourceRoot : sourceRoots) {
            Files.filter(sourceRoot, App.F.JAVA_SOURCE, new Lang.Visitor<File>(){

                public void visit(File file) throws Lang.Break {
                    Source source = Source.ofFile(sourceRoot, file);
                    if (null != source) {
                        if (null == DevModeClassLoader.this.sources) {
                            DevModeClassLoader.this.sources = new HashMap();
                        }
                        DevModeClassLoader.this.sources.put(source.className(), source);
                    }
                }
            });
        }
    }

    private void preloadSource(List<File> sourceRoot, String className) {
        Source source;
        if (null != this.sources && null != (source = this.sources.get(className))) {
            return;
        }
        source = Source.ofClass(sourceRoot, className);
        if (null != source) {
            if (null == this.sources) {
                this.sources = new HashMap<String, Source>();
            }
            this.sources.put(source.className(), source);
        }
    }

    private void compileSources() {
        logger.debug("start to compile sources ...");
        this.compiler.compile(this.sources.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanSources() {
        Timer timer = this.metric.startTimer("act:classload:scan:scanSources");
        try {
            logger.debug("start to scan sources...");
            C.List<AppSourceCodeScanner> scanners = this.app().scannerManager().sourceCodeScanners();
            C.Set classesNeedByteCodeScan = C.newSet();
            if (scanners.isEmpty()) {
                for (String className : this.sources.keySet()) {
                    classesNeedByteCodeScan.add(className);
                }
            } else {
                for (String className : this.sources.keySet()) {
                    classesNeedByteCodeScan.add(className);
                    logger.debug("scanning %s ...", new Object[]{className});
                    ArrayList<AppSourceCodeScanner> l = new ArrayList<AppSourceCodeScanner>();
                    for (AppSourceCodeScanner scanner : scanners) {
                        if (!scanner.start(className)) continue;
                        l.add(scanner);
                    }
                    Source source = this.source(className);
                    String[] lines = source.code().split("[\\n\\r]+");
                    int j = lines.length;
                    for (int i = 0; i < j; ++i) {
                        String line = lines[i];
                        for (AppSourceCodeScanner scanner : l) {
                            scanner.visit(i, line, className);
                        }
                    }
                }
            }
            if (classesNeedByteCodeScan.isEmpty()) {
                return;
            }
            C.Set embeddedClassNames = C.newSet();
            this.scanByteCode((Iterable<String>)classesNeedByteCodeScan, (Lang.Function<String, byte[]>)new Lang.F1<String, byte[]>((Set)embeddedClassNames){
                final /* synthetic */ Set val$embeddedClassNames;
                {
                    this.val$embeddedClassNames = set;
                }

                public byte[] apply(String s) throws NotAppliedException, Lang.Break {
                    return DevModeClassLoader.this.bytecodeFromSource(s, this.val$embeddedClassNames);
                }
            });
            while (!embeddedClassNames.isEmpty()) {
                C.Set embeddedClassNameCopy = C.newSet((Collection)embeddedClassNames);
                this.scanByteCode((Iterable<String>)embeddedClassNameCopy, (Lang.Function<String, byte[]>)new Lang.F1<String, byte[]>((Set)embeddedClassNames){
                    final /* synthetic */ Set val$embeddedClassNames;
                    {
                        this.val$embeddedClassNames = set;
                    }

                    public byte[] apply(String s) throws NotAppliedException, Lang.Break {
                        return DevModeClassLoader.this.bytecodeFromSource(s, this.val$embeddedClassNames);
                    }
                });
                embeddedClassNames.removeAll((Collection<?>)embeddedClassNameCopy);
            }
        }
        finally {
            timer.stop();
        }
    }

    private byte[] bytecodeFromSource(String name, boolean compile) {
        Source source = this.source(name);
        if (null == source) {
            return null;
        }
        byte[] bytes = source.bytes();
        if (null == bytes && compile) {
            this.compiler.compile(name);
            bytes = source.bytes();
        }
        if (name.contains("$")) {
            String innerClassName = S.afterFirst((String)name, (String)"$");
            return source.bytes(innerClassName);
        }
        return bytes;
    }

    private byte[] bytecodeFromSource(String name, Set<String> embeddedClassNames) {
        Source source = this.source(name);
        if (null == source) {
            return null;
        }
        byte[] bytes = source.bytes();
        if (null == bytes) {
            this.compiler.compile(name);
            bytes = source.bytes();
        }
        if (name.contains("$")) {
            String innerClassName = S.afterFirst((String)name, (String)"$");
            return source.bytes(innerClassName);
        }
        embeddedClassNames.addAll((Collection<String>)C.list(source.innerClassNames()).map((Lang.Function)S.F.prepend((String)(name + "$"))));
        return bytes;
    }

    @Override
    public void detectChanges() {
        for (FsChangeDetector detector : this.detectors) {
            this.detectChanges(detector);
        }
        super.detectChanges();
    }

    private void detectChanges(FsChangeDetector detector) {
        if (null != detector) {
            detector.detectChanges();
        }
    }

    private void setupFsChangeDetectors() {
        ProjectLayout layout = this.app().layout();
        File appBase = this.app().base();
        C.List bases = C.newList((Object)appBase);
        bases.addAll(this.app().config().moduleBases());
        boolean isTest = "test".equals(Act.profile());
        for (File base : bases) {
            this.addDetector(layout.source(base), App.F.JAVA_SOURCE, this.sourceChangeListener);
            this.addDetector(layout.lib(base), App.F.JAR_FILE, this.libChangeListener);
            File rsrc = layout.resource(base);
            this.addDetector(rsrc, (Lang.Predicate<String>)App.F.CONF_FILE.or(new Lang.Function[]{App.F.ROUTES_FILE}), this.confChangeListener);
            this.addDetector(rsrc, null, this.resourceChangeListener);
            if (!isTest) continue;
            this.addDetector(layout.testSource(base), App.F.JAVA_SOURCE, this.sourceChangeListener);
            this.addDetector(layout.testLib(base), App.F.JAR_FILE, this.libChangeListener);
            File testRsrc = layout.testResource(base);
            this.addDetector(testRsrc, (Lang.Predicate<String>)App.F.CONF_FILE.or(new Lang.Function[]{App.F.ROUTES_FILE}), this.confChangeListener);
            this.addDetector(testRsrc, null, this.resourceChangeListener);
        }
    }

    private void addDetector(File base, Lang.Predicate<String> predicate, FsEventListener listener) {
        if (null != base && base.isDirectory()) {
            this.detectors.add(new FsChangeDetector(base, predicate, listener));
        }
    }

    private class ResourceChangeListener
    implements FsEventListener {
        private ResourceChangeListener() {
        }

        @Override
        public void on(FsEvent ... events) {
            block4: for (FsEvent e : events) {
                List<String> paths = e.paths();
                File[] files = new File[paths.size()];
                int idx = 0;
                for (String path : paths) {
                    files[idx++] = new File(path);
                }
                switch (e.kind()) {
                    case CREATE: 
                    case MODIFY: {
                        DevModeClassLoader.this.app().builder().copyResources(files);
                        continue block4;
                    }
                    case DELETE: {
                        DevModeClassLoader.this.app().builder().removeResources(files);
                        continue block4;
                    }
                    default: {
                        assert (false);
                        continue block4;
                    }
                }
            }
        }
    }
}

