/*
 * Decompiled with CFR 0.152.
 */
package act.app;

import act.Act;
import act.app.App;
import act.app.ProjectLayout;
import act.app.util.NamedPort;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgl.util.S;

public enum RuntimeDirs {

    public static final String CONF = "/conf";
    public static final String ASSET = "/asset";
    public static final String CLASSES = "/classes";
    public static final String LIB = "/lib";

    public static File home(App app) {
        if (Act.isDev()) {
            return app.layout().target(app.base());
        }
        return app.base();
    }

    public static File resource(App app) {
        return app.layout().resource(Act.isDev() ? app.base() : app.home());
    }

    public static File conf(App app) {
        File confBase = app.layout().resource(Act.isDev() ? app.base() : app.home());
        File file = new File(confBase, CONF);
        return file.exists() ? file : confBase;
    }

    public static Map<String, List<File>> routes(App app) {
        HashMap<String, List<File>> map = new HashMap<String, List<File>>();
        File classes = RuntimeDirs.classes(app);
        map.put("default", RuntimeDirs.routes(classes, "routes.conf"));
        for (NamedPort np : app.config().namedPorts()) {
            String npName = np.name();
            String routesConfName = S.concat((String)"routes.", (String)npName, (String)".conf");
            map.put(npName, RuntimeDirs.routes(classes, routesConfName));
        }
        return map;
    }

    private static List<File> routes(File classes, String name) {
        ArrayList<File> routes = new ArrayList<File>();
        routes.add(ProjectLayout.Utils.file(classes, name));
        File confRoot = ProjectLayout.Utils.file(classes, CONF);
        routes.add(ProjectLayout.Utils.file(confRoot, name));
        File profileRooot = ProjectLayout.Utils.file(confRoot, Act.profile());
        routes.add(ProjectLayout.Utils.file(profileRooot, name));
        return routes;
    }

    public static File classes(App app) {
        File file = new File(app.home(), app.layout().classes());
        if (!file.exists()) {
            file = new File(app.layout().target(app.home()), app.layout().classes());
        }
        return file;
    }

    public static File lib(App app) {
        return new File(app.home(), LIB);
    }
}

