/*
 * Decompiled with CFR 0.152.
 */
package act.app.conf;

import act.app.event.SysEventId;
import act.conf.AppConfig;
import act.security.CSRFProtector;
import act.util.LogSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgl.$;
import org.osgl.http.H;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.S;
import org.osgl.util.StringValueResolver;

public abstract class AppConfigurator<T extends AppConfigurator>
extends AppConfig<T> {
    protected static final H.Method GET = H.Method.GET;
    protected static final H.Method POST = H.Method.POST;
    protected static final H.Method PUT = H.Method.PUT;
    protected static final H.Method DELETE = H.Method.DELETE;
    private transient Set<String> controllerClasses = new HashSet<String>();
    private Map<String, Object> userProps = new HashMap<String, Object>();

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return this.getClass().getName();
    }

    @Override
    protected void releaseResources() {
        this.controllerClasses.clear();
        this.userProps.clear();
        this.releaseAppConfigResources();
        super.releaseResources();
    }

    protected T registerStringValueResolver(Class<T> targetType, StringValueResolver<T> resolver) {
        this.app().resolverManager().register(targetType, resolver);
        return this.me();
    }

    protected CorsSetting cors() {
        return new CorsSetting(this);
    }

    protected CsrfSetting csrf() {
        return new CsrfSetting(this);
    }

    public void onRouteAdded(String controllerClassName) {
        this.controllerClasses.add(controllerClassName);
    }

    public Set<String> controllerClasses() {
        return C.newSet(this.controllerClasses);
    }

    protected T prop(String key, Object val) {
        this.userProps.put(key, val);
        return this.me();
    }

    public Set<String> propKeys() {
        return this.userProps.keySet();
    }

    public <V> V propVal(String key) {
        return (V)$.cast((Object)this.userProps.get(key));
    }

    public abstract void configure();

    protected void releaseAppConfigResources() {
    }

    protected static class CorsSetting
    extends LogSupport {
        private AppConfigurator conf;
        private boolean enabled;
        private String allowOrigin;
        private int maxAge;
        private List<String> headersBoth = new ArrayList<String>();
        private List<String> headersAllowed = new ArrayList<String>();
        private List<String> headersExpose = new ArrayList<String>();

        CorsSetting(AppConfigurator conf) {
            this.conf = conf;
            this.enabled = true;
            conf.app().jobManager().on(SysEventId.CONFIG_PREMERGE, new Runnable(){

                @Override
                public void run() {
                    CorsSetting.this.checkAndCommit();
                }
            });
        }

        public CorsSetting enable() {
            this.enabled = true;
            return this;
        }

        public CorsSetting disable() {
            this.enabled = false;
            return this;
        }

        public CorsSetting allowOrigin(String allowOrigin) {
            E.illegalArgumentIf((boolean)S.blank((String)allowOrigin), (String)"allow origin cannot be empty");
            this.allowOrigin = allowOrigin;
            return this;
        }

        public CorsSetting maxAge(int maxAge) {
            E.illegalArgumentIf((maxAge < 0 ? 1 : 0) != 0);
            this.maxAge = maxAge;
            return this;
        }

        public CorsSetting allowHeaders(String ... headers) {
            this.headersAllowed.addAll((Collection<String>)C.listOf((Object[])headers));
            return this;
        }

        public CorsSetting exposeHeaders(String ... headers) {
            this.headersExpose.addAll((Collection<String>)C.listOf((Object[])headers));
            return this;
        }

        public CorsSetting allowAndExposeHeaders(String ... headers) {
            this.headersBoth.addAll((Collection<String>)C.listOf((Object[])headers));
            return this;
        }

        private void checkAndCommit() {
            if (!this.enabled) {
                this.logger.info("Global CORS is disabled");
                this.conf.enableCors(false);
                return;
            }
            this.logger.info("Global CORS is enabled");
            this.conf.enableCors(true);
            this.conf.corsAllowOrigin(this.allowOrigin);
            this.conf.corsHeaders(this.consolidate(this.headersBoth));
            this.conf.corsAllowHeaders(this.consolidate(this.headersAllowed));
            this.conf.corsHeadersExpose(this.consolidate(this.headersExpose));
            this.conf.corsMaxAge(this.maxAge);
        }

        private String consolidate(List<String> stringList) {
            if (stringList.isEmpty()) {
                return null;
            }
            HashSet set = new HashSet();
            for (String s : stringList) {
                set.addAll(C.listOf((Object[])s.split(",")));
            }
            return S.join((String)", ", set);
        }
    }

    protected static class CsrfSetting
    extends LogSupport {
        private AppConfigurator conf;
        private boolean enabled;
        private String headerName;
        private String paramName;
        private String cookieName;
        private CSRFProtector protector;

        CsrfSetting(AppConfigurator conf) {
            this.conf = conf;
            this.enabled = true;
            conf.app().jobManager().on(SysEventId.CONFIG_PREMERGE, new Runnable(){

                @Override
                public void run() {
                    CsrfSetting.this.checkAndCommit();
                }
            });
        }

        public CsrfSetting enable() {
            this.enabled = true;
            return this;
        }

        public CsrfSetting disable() {
            this.enabled = false;
            return this;
        }

        public CsrfSetting headerName(String name) {
            this.headerName = name;
            return this;
        }

        public CsrfSetting paramName(String name) {
            this.paramName = name;
            return this;
        }

        public CsrfSetting cookieName(String name) {
            this.cookieName = name;
            return this;
        }

        public CsrfSetting protector(CSRFProtector protector) {
            this.protector = (CSRFProtector)$.notNull((Object)protector);
            return this;
        }

        private void checkAndCommit() {
            if (!this.enabled) {
                this.logger.info("Global CSRF is disabled");
                this.conf.enableCsrf(false);
            }
            this.logger.info("Global CSRF is enabled");
            this.conf.csrfCookieName(this.cookieName);
            this.conf.csrfHeaderName(this.headerName);
            this.conf.csrfParamName(this.paramName);
            this.conf.csrfProtector(this.protector);
        }
    }
}

